/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.trigger;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.plan.trigger.PlanTrigger;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.plugin.descriptor.PlanTriggerModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.TriggerReasonModuleDescriptor;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReasonRenderer;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import io.atlassian.util.concurrent.LazyReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TriggerManagerImpl
implements TriggerManager {
    private static final Logger log = Logger.getLogger(TriggerManagerImpl.class);
    private final PluginAccessor pluginAccessor;
    private final LazyReference<TriggerReason> unknownTriggerReason = new LazyReference<TriggerReason>(){

        protected TriggerReason create() throws Exception {
            ModuleDescriptor moduleDescriptor = TriggerManagerImpl.this.pluginAccessor.getPluginModule("com.atlassian.bamboo.plugin.system.triggerReason:UnknownTriggerReason");
            if (moduleDescriptor == null) {
                throw new IllegalStateException("Could not load TriggerReason module with key 'com.atlassian.bamboo.plugin.system.triggerReason:UnknownTriggerReason'");
            }
            return (TriggerReason)moduleDescriptor.getModule();
        }
    };

    public TriggerManagerImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @NotNull
    public PlanTrigger getPlanTrigger(@NotNull String completeKey) throws IllegalArgumentException {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getPluginModule(completeKey);
        ModuleDescriptor planTriggerModuleDescriptor = (ModuleDescriptor)Narrow.reinterpret((Object)moduleDescriptor, PlanTriggerModuleDescriptor.class);
        if (planTriggerModuleDescriptor == null) {
            throw new IllegalArgumentException("complete plugin key for PlanTrigger '" + completeKey + "' has module descriptor type of '" + moduleDescriptor.getClass() + "' and not '" + PlanTriggerModuleDescriptor.class);
        }
        return (PlanTrigger)planTriggerModuleDescriptor.getModule();
    }

    @NotNull
    public TriggerReason getTriggerReason(@NotNull ChainResultsSummary chainResultsSummary, @NotNull BuildResultsSummary buildResultsSummary) {
        HashMap<String, String> triggerReasonMap = new HashMap<String, String>();
        triggerReasonMap.putAll(chainResultsSummary.getCustomBuildData());
        triggerReasonMap.putAll(buildResultsSummary.getCustomBuildData());
        triggerReasonMap.computeIfAbsent("buildKey", key -> buildResultsSummary.getPlanResultKey().getKey());
        return this.getTriggerReason(chainResultsSummary.getTriggerReason().getKey(), triggerReasonMap);
    }

    @NotNull
    public TriggerReason getTriggerReason(@NotNull BuildContext buildContext) {
        String triggerReasonKey = buildContext.getTriggerReason().getKey();
        Map customBuildData = buildContext.getBuildResult().getCustomBuildData();
        customBuildData.computeIfAbsent("buildKey", key -> buildContext.getBuildResultKey());
        return this.getTriggerReason(triggerReasonKey, customBuildData);
    }

    @NotNull
    public TriggerReason getTriggerReason(@NotNull String key, @NotNull Map<String, String> fieldsMap) {
        TriggerReason triggerReason = this.getTriggerReasonForKey(key);
        triggerReason.init(key, fieldsMap);
        return triggerReason;
    }

    @NotNull
    public TriggerReason getTriggerReason(@NotNull String key, @NotNull ResultsSummary resultsSummary) {
        TriggerReason triggerReason = this.getTriggerReasonForKey(key);
        triggerReason.init(key, resultsSummary);
        return triggerReason;
    }

    @NotNull
    public TriggerReasonRenderer getTriggerReasonRenderer(@NotNull TriggerReason triggerReason, @NotNull ResultsSummary resultsSummary) {
        TriggerReasonModuleDescriptor moduleDescriptor = (TriggerReasonModuleDescriptor)this.pluginAccessor.getPluginModule(triggerReason.getKey());
        TriggerReasonRenderer reasonRenderer = moduleDescriptor.getTriggerReasonRenderer();
        reasonRenderer.init((ModuleDescriptor)moduleDescriptor, triggerReason, resultsSummary);
        return reasonRenderer;
    }

    @NotNull
    public TriggerReasonRenderer getTriggerReasonRenderer(@NotNull TriggerReason triggerReason, @NotNull CurrentlyBuilding currentlyBuilding) {
        TriggerReasonModuleDescriptor moduleDescriptor = (TriggerReasonModuleDescriptor)this.pluginAccessor.getPluginModule(triggerReason.getKey());
        TriggerReasonRenderer reasonRenderer = moduleDescriptor.getTriggerReasonRenderer();
        reasonRenderer.init((ModuleDescriptor)moduleDescriptor, triggerReason, currentlyBuilding);
        return reasonRenderer;
    }

    @NotNull
    public TriggerReasonRenderer getTriggerReasonRenderer(@NotNull TriggerReason triggerReason) {
        TriggerReasonModuleDescriptor moduleDescriptor = (TriggerReasonModuleDescriptor)this.pluginAccessor.getPluginModule(triggerReason.getKey());
        TriggerReasonRenderer reasonRenderer = moduleDescriptor.getTriggerReasonRenderer();
        reasonRenderer.init((ModuleDescriptor)moduleDescriptor, triggerReason);
        return reasonRenderer;
    }

    @NotNull
    private TriggerReason getTriggerReasonForKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return (TriggerReason)this.unknownTriggerReason.get();
        }
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getPluginModule(key);
        if (moduleDescriptor == null) {
            return (TriggerReason)this.unknownTriggerReason.get();
        }
        return (TriggerReason)moduleDescriptor.getModule();
    }
}

