/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.vcsRevision;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.hibernate.HibernateBambooEntityObject;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="PLAN_VCS_HISTORY")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@Internal
public class PlanVcsRevisionHistoryItem
extends HibernateBambooEntityObject {
    @Column(name="PLAN_KEY")
    @Type(type="com.atlassian.bamboo.plan.PlanKeyUserType")
    private PlanKey planKey;
    @Column(name="BUILD_NUMBER")
    private int buildNumber;
    @Column(name="REVISION_KEY")
    private String vcsRevisionKey;
    @Column(name="VCS_LOCATION_ID")
    private long repositoryId = -1L;
    @Column(name="XML_CUSTOM_DATA")
    @Type(type="com.atlassian.hibernate.BucketClobStringType")
    private String customXmlData;

    public PlanVcsRevisionHistoryItem() {
    }

    public PlanVcsRevisionHistoryItem(@NotNull PlanKey planKey, int buildNumber, @NotNull PlanVcsRevisionData planVcsRevisionData, long repositoryId) {
        this.planKey = planKey;
        this.buildNumber = buildNumber;
        this.vcsRevisionKey = planVcsRevisionData.getVcsRevisionKey();
        this.customXmlData = planVcsRevisionData.getCustomXmlData();
        this.repositoryId = repositoryId;
    }

    public PlanKey getPlanKey() {
        return this.planKey;
    }

    public void setPlanKey(PlanKey planKey) {
        this.planKey = planKey;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getVcsRevisionKey() {
        return this.vcsRevisionKey;
    }

    public void setVcsRevisionKey(String vcsRevisionKey) {
        this.vcsRevisionKey = vcsRevisionKey;
    }

    public long getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(long repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Nullable
    public String getCustomXmlData() {
        return this.customXmlData;
    }

    public void setCustomXmlData(@Nullable String customXmlData) {
        this.customXmlData = customXmlData;
    }

    public PlanVcsRevisionData asRevisionData() {
        return new PlanVcsRevisionData(this.vcsRevisionKey, this.customXmlData);
    }
}

