/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.vcsRevision;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryDao;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryItem;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryManager;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PlanVcsRevisionHistoryManagerImpl
implements PlanVcsRevisionHistoryManager {
    private static final Logger log = Logger.getLogger(PlanVcsRevisionHistoryManagerImpl.class);
    private final PlanVcsRevisionHistoryDao planVcsRevisionHistoryDao;

    public PlanVcsRevisionHistoryManagerImpl(PlanVcsRevisionHistoryDao planVcsRevisionHistoryDao) {
        this.planVcsRevisionHistoryDao = planVcsRevisionHistoryDao;
    }

    @Override
    @NotNull
    public Map<Long, PlanVcsRevisionData> getLastVcsRevisionKeys(@NotNull PlanKey planKey) {
        HashMap<Long, PlanVcsRevisionData> result = new HashMap<Long, PlanVcsRevisionData>();
        for (PlanVcsRevisionHistoryItem historyItem : this.planVcsRevisionHistoryDao.findLatestVcsRevisionHistoryItems(planKey)) {
            result.put(historyItem.getRepositoryId(), historyItem.asRevisionData());
        }
        return result;
    }

    @Override
    @NotNull
    public Map<Long, PlanVcsRevisionData> getLastVcsRevisionKeysBeforeBuildNumber(@NotNull PlanKey planKey, int buildNumber) {
        HashMap<Long, PlanVcsRevisionData> result = new HashMap<Long, PlanVcsRevisionData>();
        for (PlanVcsRevisionHistoryItem historyItem : this.planVcsRevisionHistoryDao.findLatestVcsRevisionHistoryItemsBeforeBuildNumber(planKey, buildNumber)) {
            result.put(historyItem.getRepositoryId(), historyItem.asRevisionData());
        }
        return result;
    }

    @Override
    public void markBuildStartedNewTx(@NotNull BuildContext buildContext) {
        Map<Long, PlanVcsRevisionData> previousRevisions = this.getLastVcsRevisionKeysBeforeBuildNumber(buildContext.getPlanResultKey().getPlanKey(), buildContext.getBuildNumber());
        for (RepositoryDefinition repositoryDefinition : buildContext.getRepositoryDefinitions()) {
            PlanVcsRevisionData revisionData = previousRevisions.get(repositoryDefinition.getId());
            buildContext.getBuildChanges().setPreviousVcsRevisionKey(repositoryDefinition.getId(), revisionData != null ? revisionData.getVcsRevisionKey() : null);
            PlanVcsRevisionHistoryItem historyItem = new PlanVcsRevisionHistoryItem(buildContext.getPlanResultKey().getPlanKey(), buildContext.getBuildNumber(), buildContext.getBuildChanges().getVcsRevisionData(repositoryDefinition.getId()), repositoryDefinition.getId());
            this.planVcsRevisionHistoryDao.createOrUpdateChangeDetectionHistoryItem(historyItem);
        }
    }

    @Override
    public void markChangeDetectionCompletedNewTx(@NotNull PlanKey planKey, int buildNumber, @NotNull PlanVcsRevisionData planVcsRevisionData, long repositoryId) {
        PlanVcsRevisionHistoryItem historyItem = new PlanVcsRevisionHistoryItem(planKey, buildNumber, planVcsRevisionData, repositoryId);
        this.planVcsRevisionHistoryDao.createOrUpdateChangeDetectionHistoryItem(historyItem);
    }

    @Override
    public void clearRevisionHistoryForPlanNewTx(@NotNull PlanKey planKey) {
        this.planVcsRevisionHistoryDao.deleteVcsRevisionHistoryForPlan(planKey);
    }

    @Override
    public void cleanupUnusedEntriesForPlan(@NotNull PlanKey planKey) {
        this.planVcsRevisionHistoryDao.cleanupUnusedEntriesForPlan(planKey);
    }

    @Override
    public void moveRevisionHistoryForPlan(@NotNull PlanKey oldPlanKey, @NotNull PlanKey newPlanKey) {
        this.planVcsRevisionHistoryDao.deleteVcsRevisionHistoryForPlan(newPlanKey);
        this.planVcsRevisionHistoryDao.moveRevisionHistoryForPlan(oldPlanKey, newPlanKey);
    }
}

