/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.vcsRevision;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionDataSet;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryManager;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.v2.build.BuildContext;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class PlanVcsRevisionHistoryServiceImpl
implements PlanVcsRevisionHistoryService {
    private final PlanVcsRevisionHistoryManager planVcsRevisionHistoryManager;
    private final Function<String, ManagedLock> lockManager = ManagedLocks.weakManagedLockFactory();

    public PlanVcsRevisionHistoryServiceImpl(@NotNull PlanVcsRevisionHistoryManager planVcsRevisionHistoryManager) {
        this.planVcsRevisionHistoryManager = planVcsRevisionHistoryManager;
    }

    @NotNull
    public PlanVcsRevisionDataSet getLastVcsRevisionKeys(@NotNull PlanKey planKey) {
        return (PlanVcsRevisionDataSet)this.lockManager.apply(planKey.getKey().intern()).withLock(() -> new PlanVcsRevisionDataSet(this.planVcsRevisionHistoryManager.getLastVcsRevisionKeys(planKey)));
    }

    public void markBuildStarted(@NotNull BuildContext buildContext) {
        this.lockManager.apply(buildContext.getPlanResultKey().getPlanKey().getKey().intern()).withLock(() -> this.planVcsRevisionHistoryManager.markBuildStartedNewTx(buildContext));
    }

    public void markChangeDetectionCompleted(@NotNull PlanKey planKey, int buildNumber, @NotNull PlanVcsRevisionData planVcsRevisionData, long repositoryId) {
        this.lockManager.apply(planKey.getKey().intern()).withLock(() -> this.planVcsRevisionHistoryManager.markChangeDetectionCompletedNewTx(planKey, buildNumber, planVcsRevisionData, repositoryId));
    }

    public void clearRevisionHistoryForPlan(@NotNull PlanKey planKey) {
        this.lockManager.apply(planKey.getKey().intern()).withLock(() -> this.planVcsRevisionHistoryManager.clearRevisionHistoryForPlanNewTx(planKey));
    }

    public void cleanupUnusedEntriesForPlan(@NotNull PlanKey planKey) {
        this.lockManager.apply(planKey.getKey().intern()).withLock(() -> this.planVcsRevisionHistoryManager.cleanupUnusedEntriesForPlan(planKey));
    }

    public void moveRevisionHistoryForPlan(@NotNull PlanKey originalPlanKey, @NotNull PlanKey planKey) {
        this.planVcsRevisionHistoryManager.moveRevisionHistoryForPlan(originalPlanKey, planKey);
    }
}

