/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.vcsRevision.cleanup;

import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.schedule.BambooScheduler;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class PlanVcsRevisionHistoryCleanupScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(PlanVcsRevisionHistoryCleanupScheduler.class);
    private final Scheduler quartzScheduler;
    private static final String VCS_CLEANUP_JOB = "planVcsHistoryCleanupJob";
    private static final String VCS_CLEANUP_GROUP = "planVcsHistoryCleanupGroup";
    private static final String VCS_CLEANUP_TRIGGER = "planVcsHistoryCleanupTrigger";
    private static final int INTERVAL_HOURS = 3;

    public PlanVcsRevisionHistoryCleanupScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    public void initialiseSchedule() {
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(new TriggerKey(VCS_CLEANUP_JOB, VCS_CLEANUP_GROUP));
            if (trigger != null && trigger.mayFireAgain()) {
                return;
            }
            JobKey jobKey = new JobKey(VCS_CLEANUP_JOB, VCS_CLEANUP_GROUP);
            JobDetail jobDetail = JobBuilder.newJob(PlanVcsHistoryCleanupJob.class).withIdentity(jobKey).build();
            trigger = TriggerBuilder.newTrigger().withIdentity(VCS_CLEANUP_TRIGGER).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatHourlyForever((int)3)).build();
            this.quartzScheduler.scheduleJob(jobDetail, trigger);
            log.info((Object)"Plan VCS Revision History Cleanup Job running every 3 hours.");
        }
        catch (SchedulerException e) {
            log.error((Object)"Unable to schedule planVcsHistoryCleanupJob", (Throwable)e);
        }
    }

    public static class PlanVcsHistoryCleanupJob
    implements Job {
        private PlanVcsRevisionHistoryService planVcsRevisionHistoryService;
        private CachedPlanManager cachedPlanManager;

        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            log.info((Object)"Starting Plan VCS Revision History Cleanup");
            for (PlanIdentifier plan : this.cachedPlanManager.getPlans()) {
                this.planVcsRevisionHistoryService.cleanupUnusedEntriesForPlan(plan.getPlanKey());
            }
        }

        public void setPlanVcsRevisionHistoryService(PlanVcsRevisionHistoryService planVcsRevisionHistoryService) {
            this.planVcsRevisionHistoryService = planVcsRevisionHistoryService;
        }

        public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
            this.cachedPlanManager = cachedPlanManager;
        }
    }
}

