/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.Plugin;
import com.google.common.base.Preconditions;

@Internal
public interface AgentPluginResolver {
    public Iterable<Plugin> getAgentPlugins(AgentPluginFilter var1);

    public boolean matches(Plugin var1, AgentPluginFilter var2);

    public static final class AgentPluginFilter {
        private boolean availableOnly;
        private boolean enabledOnly;
        private boolean userInstalled;
        private boolean systemProvided;
        private boolean nonBundledOnly;

        public static AgentPluginFilter newFilter() {
            return new AgentPluginFilter();
        }

        private AgentPluginFilter() {
        }

        public boolean isEnabledOnly() {
            return this.enabledOnly;
        }

        public AgentPluginFilter setEnabledOnly() {
            Preconditions.checkState((!this.availableOnly ? 1 : 0) != 0, (Object)"You must choose either enabledOnly or availableOnly, not both");
            this.enabledOnly = true;
            return this;
        }

        public AgentPluginFilter setAvailableOnly() {
            Preconditions.checkState((!this.enabledOnly ? 1 : 0) != 0, (Object)"You must choose either enabledOnly or availableOnly, not both");
            this.availableOnly = true;
            return this;
        }

        public boolean isAvailableOnly() {
            return this.availableOnly;
        }

        public boolean isUserInstalledOnly() {
            return this.userInstalled;
        }

        public boolean nonBundledOnly() {
            return this.nonBundledOnly;
        }

        public AgentPluginFilter setNonBundledOnly() {
            this.nonBundledOnly = true;
            return this;
        }

        public AgentPluginFilter setUserInstalledOnly() {
            this.userInstalled = true;
            return this;
        }

        public boolean isSystemProvided() {
            return this.systemProvided;
        }

        public AgentPluginFilter setSystemProvidedOnly() {
            this.systemProvided = true;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AgentPluginFilter that = (AgentPluginFilter)o;
            if (this.availableOnly != that.availableOnly) {
                return false;
            }
            if (this.enabledOnly != that.enabledOnly) {
                return false;
            }
            if (this.nonBundledOnly != that.nonBundledOnly) {
                return false;
            }
            if (this.systemProvided != that.systemProvided) {
                return false;
            }
            return this.userInstalled == that.userInstalled;
        }

        public int hashCode() {
            int result = this.availableOnly ? 1 : 0;
            result = 31 * result + (this.enabledOnly ? 1 : 0);
            result = 31 * result + (this.userInstalled ? 1 : 0);
            result = 31 * result + (this.systemProvided ? 1 : 0);
            result = 31 * result + (this.nonBundledOnly ? 1 : 0);
            return result;
        }
    }
}

