/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin;

import com.atlassian.bamboo.utils.predicates.text.TextPredicates;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDownloaderTaskConfigurationHelper {
    public static final String SOURCE_PLAN_KEY = "sourcePlanKey";
    public static final String ARTIFACT_ID = "artifactId";
    public static final String RUNTIME_ARTIFACT_IDS = "runtimeArtifactIds";
    public static final String TRANSFER_ID = "transferId";
    public static final String ARTIFACT_NAME = "artifactName";
    public static final String LOCAL_PATH = "localPath";
    public static final String ARTIFACT_PATTERN = "artifactPattern";
    public static final String AVAILABLE_ARTIFACTS = "availableArtifacts";

    private ArtifactDownloaderTaskConfigurationHelper() {
    }

    public static String getCopyPattern(@NotNull Map<String, String> map, int i) {
        return map.get(ArtifactDownloaderTaskConfigurationHelper.getKey(ARTIFACT_PATTERN, i));
    }

    public static String getLocalPath(@NotNull Map<String, String> map, int i) {
        return map.get(ArtifactDownloaderTaskConfigurationHelper.getKey(LOCAL_PATH, i));
    }

    public static void setLocalPath(@NotNull Map<String, String> map, int i, String localPath) {
        map.put(ArtifactDownloaderTaskConfigurationHelper.getKey(LOCAL_PATH, i), localPath);
    }

    public static void setCopyPattern(@NotNull Map<String, String> map, int i, String copyPattern) {
        map.put(ArtifactDownloaderTaskConfigurationHelper.getKey(ARTIFACT_PATTERN, i), copyPattern);
    }

    public static void setRuntimeArtifactIds(@NotNull Map<String, String> map, int i, @NotNull Collection<? extends Number> value) {
        map.put(ArtifactDownloaderTaskConfigurationHelper.getKey(RUNTIME_ARTIFACT_IDS, i), Joiner.on((char)',').join(value));
    }

    public static Collection<Integer> getRuntimeArtifactIds(@NotNull Map<String, String> map, int i) {
        ArrayList<Integer> runtimeArtifactIds = new ArrayList<Integer>();
        String value = map.get(ArtifactDownloaderTaskConfigurationHelper.getKey(RUNTIME_ARTIFACT_IDS, i));
        if (StringUtils.isNotBlank((CharSequence)value)) {
            for (String runtimeArtifactId : Splitter.on((char)',').split((CharSequence)value)) {
                runtimeArtifactIds.add(Integer.valueOf(runtimeArtifactId));
            }
        }
        return runtimeArtifactIds;
    }

    @Nullable
    public static <T> T getSourcePlanKey(@NotNull Map<String, T> configuration) {
        return configuration.get(SOURCE_PLAN_KEY);
    }

    public static <T> void setSourcePlanKey(@NotNull Map<String, T> map, @NotNull T value) {
        map.put(SOURCE_PLAN_KEY, value);
    }

    public static <T> void setArtifactName(@NotNull Map<String, T> map, int i, @NotNull T value) {
        map.put(ArtifactDownloaderTaskConfigurationHelper.getArtifactNameKey(i), value);
    }

    public static <T> void setArtifactId(@NotNull Map<String, T> map, int i, @NotNull T value) {
        map.put(ArtifactDownloaderTaskConfigurationHelper.getArtifactIdKey(i), value);
    }

    public static long getArtifactId(@NotNull Map<String, String> map, int i) {
        return Long.parseLong(map.get(ArtifactDownloaderTaskConfigurationHelper.getArtifactIdKey(i)));
    }

    public static String getArtifactName(@NotNull Map<String, String> map, int i) {
        return map.get(ArtifactDownloaderTaskConfigurationHelper.getArtifactNameKey(i));
    }

    public static String getArtifactIdKey(int i) {
        return ArtifactDownloaderTaskConfigurationHelper.getKey(ARTIFACT_ID, i);
    }

    public static String getArtifactNameKey(int i) {
        return ArtifactDownloaderTaskConfigurationHelper.getKey(ARTIFACT_NAME, i);
    }

    public static Iterable<String> getTransferKeys(@NotNull Map<String, ?> config) {
        return ArtifactDownloaderTaskConfigurationHelper.getKeys(config, TRANSFER_ID);
    }

    public static Iterable<String> getArtifactKeys(@NotNull Map<String, ?> config) {
        return ArtifactDownloaderTaskConfigurationHelper.getKeys(config, ARTIFACT_ID);
    }

    public static Iterable<String> getPathKeys(@NotNull Map<String, ?> config) {
        return ArtifactDownloaderTaskConfigurationHelper.getKeys(config, LOCAL_PATH);
    }

    private static Iterable<String> getKeys(@NotNull Map<String, ?> config, @NotNull String startsWith) {
        return Iterables.filter(config.keySet(), TextPredicates.startsWith((String)startsWith)::test);
    }

    public static int getIndexFromKey(@NotNull String key) {
        Iterable tokens = Splitter.on((String)"_").trimResults().split((CharSequence)key);
        String number = (String)Iterables.getLast((Iterable)tokens);
        return Integer.parseInt(number);
    }

    private static String getKey(String name, int i) {
        return String.format("%s_%d", name, i);
    }
}

