/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin;

import com.atlassian.plugin.hostcontainer.HostContainer;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BambooHostContainer
implements HostContainer,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger(BambooHostContainer.class);
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T create(Class<T> moduleClass) throws IllegalArgumentException {
        Constructor<?>[] constructors;
        boolean hasMultipleArgumentConstructor = false;
        try {
            constructors = moduleClass.getConstructors();
        }
        catch (LinkageError e) {
            log.error((Object)("Error in plugin class: " + moduleClass.getCanonicalName()));
            throw e;
        }
        for (Constructor<?> constructor : constructors) {
            boolean bl = hasMultipleArgumentConstructor = constructor.getParameterTypes().length > 0;
            if (hasMultipleArgumentConstructor) break;
        }
        if (hasMultipleArgumentConstructor) {
            try {
                return (T)this.applicationContext.getAutowireCapableBeanFactory().createBean(moduleClass, 3, false);
            }
            catch (UnsatisfiedDependencyException e) {
                log.debug((Object)("Could not autowire by constructor for '" + moduleClass + "'. Falling back to autodetect then by name."), (Throwable)e);
            }
        }
        String string = moduleClass.getName().intern();
        synchronized (string) {
            try {
                return (T)this.applicationContext.getAutowireCapableBeanFactory().createBean(moduleClass, 4, false);
            }
            catch (UnsatisfiedDependencyException e) {
                return (T)this.applicationContext.getAutowireCapableBeanFactory().createBean(moduleClass, 1, false);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

