/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin;

import com.atlassian.bamboo.plugin.PluginAwareStrutsLocalizedTextProvider;
import com.atlassian.bamboo.plugin.SystemPluginLoaderConfiguration;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.i18n.BambooTextProvider;
import com.atlassian.bamboo.utils.i18n.DocumentationLinkProvider;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginSystemLifecycle;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.classloader.PluginsClassLoader;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.repositories.FilePluginInstaller;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.wiring.BundleWiring;
import org.springframework.context.annotation.Lazy;

public class BambooPluginManager
extends DefaultPluginManager
implements PluginController,
PluginAccessor,
PluginSystemLifecycle {
    private static final Logger log = Logger.getLogger(BambooPluginManager.class);
    private static volatile boolean shouldPersistPluginState = true;
    @VisibleForTesting
    static final String I18N = "i18n";
    private static final Set<String> pluginBlacklist = Sets.newHashSet((Object[])new String[]{"com.atlassian.buildeng.hung-build-killer"});
    private static final Multimap<String, String> pluginVersionBlacklist = new ImmutableMultimap.Builder().putAll((Object)"com.atlassian.labs.bamboo.git", Arrays.asList("1.2.2", "1.2.3", "1.2.4")).build();
    @Inject
    @Lazy
    private DocumentationLinkProvider documentationLinkProvider;
    private final PluginMetadataManager pluginMetadataManager;

    public BambooPluginManager(PluginPersistentStateStore pluginStateStore, SystemPluginLoaderConfiguration loaderConfiguration, List<PluginLoader> extraPluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager, File pluginDirectory, PluginMetadataManager pluginMetadataManager) {
        super(pluginStateStore, (List)Lists.newArrayList((Iterable)Iterables.concat(loaderConfiguration.pluginLoaders(), (Iterable)Iterables.filter(extraPluginLoaders, Objects::nonNull))), moduleDescriptorFactory, pluginEventManager);
        this.pluginMetadataManager = pluginMetadataManager;
        if (pluginDirectory != null) {
            FilePluginInstaller installer = new FilePluginInstaller(pluginDirectory);
            this.setPluginInstaller((PluginInstaller)installer);
        }
        PluginAwareStrutsLocalizedTextProvider.withClassLoader(BambooTextProvider.getMainAppClassloader(), () -> PluginAwareStrutsLocalizedTextProvider.getInstance().setDelegatedClassLoader((ClassLoader)this.getClassLoader()));
    }

    protected void addPlugins(@Nullable PluginLoader loader, Collection<Plugin> pluginsToInstall) throws PluginParseException {
        this.enableRequiredPlugins(pluginsToInstall);
        super.addPlugins(loader, pluginsToInstall);
    }

    void enableRequiredPlugins(Collection<Plugin> pluginsToInstall) {
        for (Plugin plugin : pluginsToInstall) {
            if (this.pluginMetadataManager.isOptional(plugin) || this.getStore().load().isEnabled(plugin)) continue;
            log.warn((Object)("Enabling required plugin with key '" + plugin.getKey() + "' which was previously disabled."));
            this.enablePluginState(plugin, this.getStore());
        }
    }

    public Collection<Plugin> getPlugins() {
        Predicate<Plugin> isPluginVersion1 = plugin -> plugin.getPluginsVersion() == 1;
        Map<Boolean, List<Plugin>> splitByVersion = super.getPlugins().stream().collect(Collectors.partitioningBy(isPluginVersion1));
        return Stream.concat(splitByVersion.get(true).stream(), splitByVersion.get(false).stream()).collect(Collectors.toCollection(ArrayList::new));
    }

    private boolean isPluginBlacklisted(Plugin plugin) {
        String pluginKey = plugin.getKey();
        return pluginBlacklist.contains(pluginKey) || pluginVersionBlacklist.containsEntry((Object)pluginKey, (Object)plugin.getPluginInformation().getVersion());
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        Plugin plugin = event.getPlugin();
        log.debug((Object)("Plugin " + plugin.getName() + " enabled"));
        if (this.isPluginBlacklisted(plugin)) {
            String pluginDescription = plugin.getName() + " (" + plugin.getKey() + ") of version " + plugin.getPluginInformation().getVersion();
            log.warn((Object)("Plugin " + pluginDescription + " is on the Bamboo blacklist - disabling it."));
            System.out.println("****************************************************************************************");
            System.out.println("* Detected blacklisted plugin: " + pluginDescription);
            System.out.println("* Please manually disable all the plans that are using this plugin");
            System.out.println("* For more details see " + this.documentationLinkProvider.getUrl("plugin.blacklist"));
            System.out.println("****************************************************************************************");
            plugin.disable();
            return;
        }
        Iterable<ResourceDescriptor> i18nResourceDescriptors = BambooPluginManager.getAllI18nResourceDescriptors(plugin);
        PluginsClassLoader pluginsClassLoader = this.getClassLoader();
        ClassLoader mainAppClassloader = BambooTextProvider.getMainAppClassloader();
        ClassLoader classLoaderOfPlugin = BambooPluginManager.getClassLoaderOfPlugin(plugin);
        if (classLoaderOfPlugin != mainAppClassloader) {
            PluginAwareStrutsLocalizedTextProvider.withClassLoader(classLoaderOfPlugin, () -> {
                PluginAwareStrutsLocalizedTextProvider.getInstance().setDelegatedClassLoader((ClassLoader)pluginsClassLoader);
                this.addResourceBundles(i18nResourceDescriptors);
            });
        }
        PluginAwareStrutsLocalizedTextProvider.withClassLoader(mainAppClassloader, () -> this.addResourceBundles(i18nResourceDescriptors));
        PluginAwareStrutsLocalizedTextProvider.withClassLoader((ClassLoader)pluginsClassLoader, () -> this.addResourceBundles(i18nResourceDescriptors));
    }

    private void addResourceBundles(Iterable<ResourceDescriptor> allI18nResourceDescriptors) {
        for (ResourceDescriptor i18nResourceDescriptor : allI18nResourceDescriptors) {
            String bundleName = i18nResourceDescriptor.getLocation();
            log.debug((Object)("Adding resource bundle: " + bundleName));
            PluginAwareStrutsLocalizedTextProvider.getInstance().clearAndAddDefaultResourceBundle(bundleName);
        }
    }

    private static Iterable<ResourceDescriptor> getAllI18nResourceDescriptors(Plugin plugin) {
        try {
            Stream pluginResources = plugin.getResourceDescriptors().stream();
            Stream moduleResources = plugin.getModuleDescriptors().stream().map(Resourced::getResourceDescriptors).flatMap(Collection::stream);
            return Stream.concat(pluginResources, moduleResources).filter(rd -> rd.getType().equals(I18N)).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            log.error((Object)("Unable to load i18n resources for: " + plugin.getName() + "(" + plugin.getKey() + ") " + e), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static ClassLoader getClassLoaderOfPlugin(Plugin plugin) {
        OsgiPlugin osgiPlugin = (OsgiPlugin)Narrow.downTo((Object)plugin, OsgiPlugin.class);
        return osgiPlugin != null ? ((BundleWiring)osgiPlugin.getBundle().adapt(BundleWiring.class)).getClassLoader() : plugin.getClassLoader();
    }

    public void disablePlugin(String key) {
        if (!shouldPersistPluginState) {
            log.warn((Object)("Not disabling '" + key + "' because plugin state storage has been disabled"));
        }
        this.disablePluginInternal(key, shouldPersistPluginState);
    }

    public static void onContextDestroyed() {
        shouldPersistPluginState = false;
        log.info((Object)"Plugin state will no longer be persisted.");
    }
}

