/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import java.util.concurrent.atomic.AtomicReference;

public class BambooPluginStateStore
implements PluginPersistentStateStore {
    private static final String STATE_KEY = "bamboo.plugin.state";
    private final BandanaManager bandanaManager;
    private final AtomicReference<PluginPersistentState> cache = new AtomicReference();

    public BambooPluginStateStore(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void save(PluginPersistentState state) {
        this.cache.set(state);
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, STATE_KEY, (Object)state);
    }

    public PluginPersistentState load() {
        if (this.cache.get() != null) {
            return this.cache.get();
        }
        this.initCache();
        return this.cache.get();
    }

    private void initCache() {
        PluginPersistentState state = this.loadFromBandana();
        if (state == null) {
            this.save(PluginPersistentState.Builder.create().toState());
        } else {
            this.cache.set(state);
        }
    }

    private PluginPersistentState loadFromBandana() {
        return (PluginPersistentState)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, STATE_KEY);
    }
}

