/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin;

import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plugin.PluginKeyProvider;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.task.TaskPredicates;
import com.atlassian.bamboo.task.TaskProcessCommandDecoratorModuleDescriptor;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooPluginUtils {
    private static final Logger log = Logger.getLogger(BambooPluginUtils.class);
    public static final String BAMBOO_APPLICATION_KEY = "bamboo";
    public static final String PLUGIN_DESCRIPTOR_FILENAME = "atlassian-plugin.xml";

    private BambooPluginUtils() {
    }

    @Nullable
    public static <T> T callUnsafeCode(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Error e) {
            if (e instanceof VirtualMachineError) {
                throw e;
            }
            log.error((Object)callable.getErrorMessage(), (Throwable)e);
            callable.onThrow(e);
        }
        catch (Exception e) {
            log.error((Object)callable.getErrorMessage(), (Throwable)e);
            callable.onThrow(e);
        }
        return null;
    }

    public static <T> T instantiateModule(ModuleDescriptor<T> md) {
        return (T)Objects.requireNonNull(md).getModule();
    }

    public static Predicate<TaskProcessCommandDecoratorModuleDescriptor> isTaskProcessCommandDecoratorApplicableTo(@NotNull TaskIdentifier taskIdentifier) {
        return moduleDescriptor -> Objects.requireNonNull(moduleDescriptor).isApplicableToTaskType(taskIdentifier.getPluginKey());
    }

    @NotNull
    public static Ordering<ModuleDescriptor<?>> getModuleDescriptorNameOrdering() {
        return ModuleDescriptorNameComparator.ORDERING;
    }

    public static Iterable<TaskDefinition> filterTasks(BuildContext buildContext, String pluginKey) {
        return BambooPluginUtils.filterTasks(buildContext.getBuildDefinition().getTaskDefinitions(), pluginKey);
    }

    public static Iterable<TaskDefinition> filterEnabledTasks(BuildContext buildContext, String pluginKey) {
        return Iterables.filter(BambooPluginUtils.filterTasks(buildContext.getBuildDefinition().getTaskDefinitions(), pluginKey), TaskPredicates.isTaskEnabled());
    }

    public static Iterable<TaskDefinition> filterTasks(Iterable<TaskDefinition> taskDefinitions, String pluginKey) {
        return Iterables.filter(taskDefinitions, BambooPluginUtils.pluginKeyEquals(pluginKey)::test);
    }

    public static <T extends TaskDefinition> Iterable<T> filterTasks(Iterable<T> taskDefinitions, com.google.common.base.Predicate<TaskDefinition> ... predicates) {
        return Iterables.filter(taskDefinitions, (com.google.common.base.Predicate)Predicates.and(predicates));
    }

    public static <T extends TaskDefinition> Iterable<T> filterEnabledTasks(Iterable<T> taskDefinitions, String pluginKey) {
        com.google.common.base.Predicate[] predicateArray = new com.google.common.base.Predicate[2];
        predicateArray[0] = BambooPluginUtils.pluginKeyEquals(pluginKey)::test;
        predicateArray[1] = TaskPredicates.isTaskEnabled();
        return BambooPluginUtils.filterTasks(taskDefinitions, predicateArray);
    }

    public static Iterable<TaskDefinition> filterTasks(ImmutableJob job, String pluginKey) {
        return BambooPluginUtils.filterTasks(job.getBuildDefinition().getTaskDefinitions(), pluginKey);
    }

    public static String prepareSubModuleConfiguration(Element element, ResettableLazyReference<?> reference, String elementName, String key, String name, String pluginKey) {
        String attributeName = "class";
        if (element.element(elementName) != null) {
            Element configuration = element.element(elementName);
            String clazz = configuration.attributeValue("class");
            if (StringUtils.isBlank((CharSequence)clazz)) {
                log.warn((Object)(name + " Module (" + key + ") of plugin " + pluginKey + " contains an incorrectly configured '" + elementName + "' element. Please use the '" + "class" + "' attribute to define your '" + elementName + "' class"));
            }
            reference.reset();
            return clazz;
        }
        return null;
    }

    public static Predicate<PluginKeyProvider> pluginKeyEquals(String pluginKey) {
        return provider -> Objects.equals(provider.getPluginKey(), pluginKey);
    }

    private static class ModuleDescriptorNameComparator
    implements Comparator<ModuleDescriptor<?>> {
        public static final Ordering<ModuleDescriptor<?>> ORDERING = Ordering.from((Comparator)new ModuleDescriptorNameComparator());

        private ModuleDescriptorNameComparator() {
        }

        @Override
        public int compare(ModuleDescriptor<?> o1, ModuleDescriptor<?> o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            String name1 = o1.getName();
            String name2 = o2.getName();
            if (name1 != null) {
                return name1.compareToIgnoreCase(name2);
            }
            if (name2 != null) {
                return -1;
            }
            return 0;
        }
    }

    private static class IsTaskProcessCommandDecoratorApplicableToPredicate
    implements com.google.common.base.Predicate<TaskProcessCommandDecoratorModuleDescriptor> {
        private final String pluginKey;

        private IsTaskProcessCommandDecoratorApplicableToPredicate(String pluginKey) {
            this.pluginKey = pluginKey;
        }

        public boolean apply(@Nullable TaskProcessCommandDecoratorModuleDescriptor input) {
            return ((TaskProcessCommandDecoratorModuleDescriptor)Preconditions.checkNotNull((Object)input)).isApplicableToTaskType(this.pluginKey);
        }
    }

    private static class InstantiateModuleFunction<T>
    implements Function<ModuleDescriptor<T>, T> {
        private InstantiateModuleFunction() {
        }

        public T apply(@Nullable ModuleDescriptor<T> input) {
            return (T)((ModuleDescriptor)Preconditions.checkNotNull(input)).getModule();
        }
    }

    public static abstract class Runnable
    extends NoThrowCallable<Void> {
        public Runnable(String errorMessage) {
            super(errorMessage);
        }

        @Override
        public final Void call() {
            this.run();
            return null;
        }

        public abstract void run();
    }

    public static abstract class NoThrowCallable<V>
    extends Callable<V> {
        public NoThrowCallable(@Nullable String errorMessage) {
            super(errorMessage);
        }

        @Override
        @Nullable
        public abstract V call();
    }

    public static abstract class Callable<V> {
        private final String errorMessage;

        public Callable(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Nullable
        public abstract V call() throws Exception;

        @Nullable
        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void onThrow(@NotNull Throwable e) {
        }
    }
}

