/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin;

import com.atlassian.bamboo.agent.classserver.ClasspathJarUtils;
import com.atlassian.bamboo.plugin.AgentPluginResolver;
import com.atlassian.bamboo.plugin.predicate.BambooPluginPredicates;
import com.atlassian.bamboo.plugin.predicate.PluginPredicateAdapter;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.predicate.PluginPredicate;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class DefaultAgentPluginResolver
implements AgentPluginResolver {
    private static final Logger log = Logger.getLogger(DefaultAgentPluginResolver.class);
    private final PluginPredicate remoteAgentSupported = PluginPredicateAdapter.adapt(BambooPluginPredicates.isRemoteAgentSupported());
    private final PluginPredicate isNotBlacklisted = PluginPredicateAdapter.adapt((Predicate<Plugin>)Predicates.not(BambooPluginPredicates.isBlacklisted(new HashSet<String>(ClasspathJarUtils.getBlackListPatterns()))));
    private final PluginPredicate enabled;
    private final PluginPredicate userInstalled;
    private final PluginPredicate systemProvided;
    private final PluginPredicate nonBundled = PluginPredicateAdapter.adapt((Predicate<Plugin>)Predicates.not(BambooPluginPredicates.isBundled()));
    private final PluginPredicate availableOnly = PluginPredicateAdapter.adapt(BambooPluginPredicates.isAvailable());
    private final PluginAccessor pluginAccessor;

    public DefaultAgentPluginResolver(PluginAccessor pluginAccessor, PluginMetadataManager pluginMetadataManager) {
        this.pluginAccessor = pluginAccessor;
        this.enabled = PluginPredicateAdapter.adapt(BambooPluginPredicates.isEnabled(pluginAccessor));
        this.userInstalled = PluginPredicateAdapter.adapt(BambooPluginPredicates.isUserInstalled(pluginMetadataManager));
        this.systemProvided = PluginPredicateAdapter.adapt(BambooPluginPredicates.isSystemProvided(pluginMetadataManager));
    }

    @Override
    public Iterable<Plugin> getAgentPlugins(AgentPluginResolver.AgentPluginFilter filter) {
        return this.pluginAccessor.getPlugins(this.getCombinedPredicate(filter));
    }

    @Override
    public boolean matches(Plugin plugin, AgentPluginResolver.AgentPluginFilter filter) {
        return this.getCombinedPredicate(filter).matches((Plugin)Preconditions.checkNotNull((Object)plugin));
    }

    private PluginPredicate getCombinedPredicate(AgentPluginResolver.AgentPluginFilter filter) {
        Preconditions.checkNotNull((Object)filter);
        return BambooPluginPredicates.and(this.isNotBlacklisted, this.remoteAgentSupported, this.enabledOrAvailablePredicate(filter), this.userInstalledPredicate(filter), this.nonBundledPredicate(filter), this.systemProvidedPredicate(filter));
    }

    private PluginPredicate enabledOrAvailablePredicate(AgentPluginResolver.AgentPluginFilter filter) {
        if (filter.isEnabledOnly()) {
            return this.enabled;
        }
        if (filter.isAvailableOnly()) {
            return this.availableOnly;
        }
        return BambooPluginPredicates.alwaysTrue();
    }

    private PluginPredicate userInstalledPredicate(AgentPluginResolver.AgentPluginFilter filter) {
        if (filter.isUserInstalledOnly()) {
            return this.userInstalled;
        }
        return BambooPluginPredicates.alwaysTrue();
    }

    private PluginPredicate nonBundledPredicate(AgentPluginResolver.AgentPluginFilter filter) {
        return filter.nonBundledOnly() ? this.nonBundled : BambooPluginPredicates.alwaysTrue();
    }

    private PluginPredicate systemProvidedPredicate(AgentPluginResolver.AgentPluginFilter filter) {
        if (filter.isSystemProvided()) {
            return this.systemProvided;
        }
        return BambooPluginPredicates.alwaysTrue();
    }
}

