/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin;

import com.atlassian.bamboo.v2.BambooPluginModule;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import org.jetbrains.annotations.NotNull;

public class ModuleAndMultiDescriptorPredicate<T>
implements ModuleDescriptorPredicate<T> {
    private final PluginAccessor pluginAccessor;
    private final Class<? extends ModuleDescriptor<?>>[] moduleDescriptorsClasses;
    private final Class<? extends BambooPluginModule> moduleClass;

    public ModuleAndMultiDescriptorPredicate(@NotNull Class<? extends BambooPluginModule> moduleClass, @NotNull PluginAccessor pluginAccessor, Class<? extends ModuleDescriptor<?>> ... moduleDescriptorsClasses) {
        this.moduleDescriptorsClasses = moduleDescriptorsClasses;
        this.moduleClass = moduleClass;
        this.pluginAccessor = pluginAccessor;
    }

    public boolean matches(@NotNull ModuleDescriptor<? extends T> moduleDescriptor) {
        for (Class<? extends ModuleDescriptor<?>> moduleDescriptorClass : this.moduleDescriptorsClasses) {
            if (!this.pluginAccessor.isPluginModuleEnabled(moduleDescriptor.getCompleteKey()) || !moduleDescriptor.getClass().isAssignableFrom(moduleDescriptorClass) || !this.moduleClass.isAssignableFrom(moduleDescriptor.getModuleClass())) continue;
            return true;
        }
        return false;
    }
}

