/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.decorator;

import com.atlassian.bamboo.plugin.BambooPluginUtils;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractUnsafeCodeDecorator<T> {
    private final T entity;

    protected AbstractUnsafeCodeDecorator(@NotNull T entity) {
        this.entity = entity;
    }

    @NotNull
    public T getEntity() {
        return this.entity;
    }

    @Nullable
    protected <V> V executeUnsafeCode(@NotNull String methodName, final @NotNull Callable<V> unsafeCallable) {
        String errorMessage = String.format("An unhandled exception occurred in '%s' while executing '%s' method", this.getEntity().getClass().getCanonicalName(), methodName);
        return (V)BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Callable<V>(errorMessage){

            @Override
            @Nullable
            public V call() throws Exception {
                return unsafeCallable.call();
            }
        });
    }

    @NotNull
    protected <V> V executeUnsafeCode(@NotNull String methodName, @NotNull Callable<V> unsafeCallable, @NotNull V defaultValue) {
        return (V)this.executeUnsafeCode(methodName, unsafeCallable, () -> defaultValue);
    }

    @NotNull
    protected <V> V executeUnsafeCode(@NotNull String methodName, @NotNull Callable<V> unsafeCallable, @NotNull Supplier<V> defaultValueSupplier) {
        V result = this.executeUnsafeCode(methodName, unsafeCallable);
        return result != null ? result : defaultValueSupplier.get();
    }

    protected void executeUnsafeCode(@NotNull String methodName, @NotNull Runnable unsafeRunnable) {
        this.executeUnsafeCode(methodName, () -> {
            unsafeRunnable.run();
            return null;
        });
    }
}

