/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.InitablePluginModule;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.ResettableLazyReference;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBambooModuleDescriptor<T>
extends AbstractModuleDescriptor<T> {
    private final ResettableLazyReference<T> moduleReference = new ResettableLazyReference<T>(){

        protected T create() throws Exception {
            return AbstractBambooModuleDescriptor.this.createModule();
        }
    };

    private T createModule() {
        Object module = this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
        this.preInit(module);
        if (module instanceof InitablePluginModule) {
            ((InitablePluginModule)module).init((ModuleDescriptor)this);
        }
        this.postInit(module);
        return (T)module;
    }

    public AbstractBambooModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Deprecated
    public AbstractBambooModuleDescriptor() {
        super(ModuleFactory.LEGACY_MODULE_FACTORY);
    }

    protected void preInit(T module) {
    }

    protected void postInit(T module) {
    }

    protected boolean isMutable() {
        return true;
    }

    @Nullable
    public T getModule() {
        BambooPluginUtils.NoThrowCallable callable = new BambooPluginUtils.NoThrowCallable<T>("Unable to instantiate module " + ((Object)((Object)this)).getClass().getName()){

            @Override
            @Nullable
            public T call() {
                return AbstractBambooModuleDescriptor.this.isMutable() ? AbstractBambooModuleDescriptor.this.createModule() : AbstractBambooModuleDescriptor.this.moduleReference.get();
            }

            @Override
            public void onThrow(@NotNull Throwable e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
        };
        return BambooPluginUtils.callUnsafeCode(callable);
    }

    public void disabled() {
        super.disabled();
        this.moduleReference.reset();
    }

    protected <Z> Z instantiateClass(Class<Z> clazz) {
        if (this.plugin instanceof ContainerManagedPlugin) {
            return (Z)((ContainerManagedPlugin)this.plugin).getContainerAccessor().createBean(clazz);
        }
        return clazz.cast(ContainerManager.getInstance().getContainerContext().createCompleteComponent(clazz));
    }

    @NotNull
    protected <Z> Z instantiateSubmodule(@NotNull String submoduleName, @NotNull String submoduleClassName, @Nullable Class<Z> defaultSubmoduleClass) throws ClassNotFoundException {
        if (StringUtils.isNotBlank((CharSequence)submoduleClassName)) {
            return this.instantiateClass(this.plugin.loadClass(submoduleClassName, ((Object)((Object)this)).getClass()));
        }
        if (defaultSubmoduleClass != null) {
            return this.instantiateClass(defaultSubmoduleClass);
        }
        throw new UnsupportedOperationException(String.format("No module '%s' defined in '%s' of class %s", submoduleName, this.getKey(), this.getModuleClassName()));
    }

    @Nullable
    protected String getFreeMarkerResourceLocation(@NotNull String resourceName) {
        ResourceDescriptor resourceDescriptor = this.getResourceDescriptor("freemarker", resourceName);
        return resourceDescriptor != null ? resourceDescriptor.getLocation() : null;
    }

    @Nullable
    protected String getVelocityResourceLocation(@NotNull String resourceName) {
        ResourceDescriptor resourceDescriptor = this.getResourceDescriptor("velocity", resourceName);
        return resourceDescriptor != null ? resourceDescriptor.getLocation() : null;
    }

    @Nullable
    protected String getElementAsString(Element element) {
        String value = null;
        if (element != null) {
            String text = element.getText();
            value = StringUtils.isNotBlank((CharSequence)text) ? text : null;
        }
        return value;
    }
}

