/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.build.artifact.ArtifactHandler;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlerConfigurator;
import com.atlassian.bamboo.plugin.RemoteAgentSupported;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptor;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RemoteAgentSupported
public class ArtifactHandlerModuleDescriptorImpl
extends AbstractBambooModuleDescriptor<ArtifactHandler>
implements ArtifactHandlerModuleDescriptor {
    private static final String CFG_CONFIGURATOR = "configurator";
    private static final String CFG_CLASS = "class";
    private static final String CFG_SUPPORTED_AGENT_TYPE = "supportedAgentType";
    public static final Map<Boolean, String> SHARED_NON_SHARED_ONOFF_OPTION_NAME = ImmutableMap.of((Object)Boolean.TRUE, (Object)"enabledForShared", (Object)Boolean.FALSE, (Object)"enabledForNonShared");
    private final Set<AgentType> supportedAgents = new HashSet<AgentType>();
    private String configuratorClassName;
    private ResettableLazyReference<ArtifactHandlerConfigurator> configuratorRef = new ResettableLazyReference<ArtifactHandlerConfigurator>(){

        protected ArtifactHandlerConfigurator create() throws Exception {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)ArtifactHandlerModuleDescriptorImpl.this.configuratorClassName), (String)"configurator class of Artifact Handler '%s' from plugin '%s' not defined", (Object[])new Object[]{ArtifactHandlerModuleDescriptorImpl.this.getKey(), ArtifactHandlerModuleDescriptorImpl.this.plugin.getKey()});
            Class configuratorClass = ArtifactHandlerModuleDescriptorImpl.this.plugin.loadClass(ArtifactHandlerModuleDescriptorImpl.this.configuratorClassName, ((Object)((Object)this)).getClass());
            ArtifactHandlerConfigurator configurator = (ArtifactHandlerConfigurator)ArtifactHandlerModuleDescriptorImpl.this.instantiateClass(configuratorClass);
            configurator.init((ModuleDescriptor)ArtifactHandlerModuleDescriptorImpl.this);
            return configurator;
        }
    };

    public ArtifactHandlerModuleDescriptorImpl(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        Element configuratorElement = element.element(CFG_CONFIGURATOR);
        Preconditions.checkArgument((configuratorElement != null ? 1 : 0) != 0, (String)"Artifact Handler module '%s' of plugin '%s' is missing a required element '%s'.", (Object[])new Object[]{this.getKey(), plugin.getKey(), CFG_CONFIGURATOR});
        this.configuratorRef.reset();
        this.configuratorClassName = configuratorElement.attributeValue(CFG_CLASS);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.configuratorClassName), (String)"Artifact Handler module '%s' of plugin '%s' contains an incorrectly configured '%s' element. Please use '%s' attribute.", (Object[])new Object[]{this.getKey(), plugin.getKey(), CFG_CONFIGURATOR, CFG_CLASS});
        Iterator supportedAgentsIterator = element.elementIterator(CFG_SUPPORTED_AGENT_TYPE);
        while (supportedAgentsIterator.hasNext()) {
            Element supportedAgentType = (Element)supportedAgentsIterator.next();
            this.supportedAgents.add(AgentType.valueOf((String)supportedAgentType.getTextTrim()));
        }
        Preconditions.checkArgument((!this.supportedAgents.isEmpty() ? 1 : 0) != 0);
    }

    @NotNull
    public ArtifactHandlerConfigurator getConfigurator() {
        return (ArtifactHandlerConfigurator)this.configuratorRef.get();
    }

    @NotNull
    public String getConfigurationPrefix() {
        return "custom.artifactHandlers." + BambooStringUtils.toCamelCase((String)this.getCompleteKey(), (char)'.');
    }

    @Nullable
    public String getEditTemplate() {
        return this.getFreeMarkerResourceLocation("edit");
    }

    public boolean supports(AgentType agentType) {
        return this.supportedAgents.contains(agentType);
    }
}

