/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.plugin.web.model.BambooWebItemBadgeProvider;
import com.atlassian.bamboo.plugin.web.model.BambooWebLabel;
import com.atlassian.bamboo.plugin.web.model.BambooWebLink;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.DefaultWebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.model.WebLink;
import java.util.Map;
import org.apache.log4j.Logger;

public class BambooWebItemModuleDescriptor
extends DefaultWebItemModuleDescriptor {
    private static final Logger log = Logger.getLogger(BambooWebItemModuleDescriptor.class);
    private BambooWebLink bambooLink;
    private BambooWebItemBadgeProvider badgeProvider;
    private final HostContainer hostContainer;

    public BambooWebItemModuleDescriptor(HostContainer hostContainer, WebInterfaceManager webInterfaceManager) {
        super(webInterfaceManager);
        this.hostContainer = hostContainer;
    }

    public void enabled() {
        super.enabled();
        if (this.element.element("label") != null) {
            try {
                this.label = new BambooWebLabel(this.element.element("label"), this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, (WebFragmentModuleDescriptor)this);
            }
            catch (PluginParseException e) {
                log.warn((Object)"Unable to parse plugin", (Throwable)e);
            }
        }
        if (this.element.element("link") != null) {
            this.bambooLink = new BambooWebLink(this.element.element("link"), this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, (WebFragmentModuleDescriptor)this);
        }
        if (this.element.element("badgeProvider") != null) {
            String className = this.element.element("badgeProvider").attributeValue("class");
            try {
                Class clazz = this.plugin.loadClass(className, ((Object)((Object)this)).getClass());
                if (this.plugin instanceof ContainerManagedPlugin) {
                    ContainerManagedPlugin cmPlugin = (ContainerManagedPlugin)this.plugin;
                    this.badgeProvider = (BambooWebItemBadgeProvider)cmPlugin.getContainerAccessor().createBean(clazz);
                } else if (clazz != null) {
                    this.badgeProvider = (BambooWebItemBadgeProvider)this.hostContainer.create(clazz);
                }
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)"Cant find badgeProvider class", (Throwable)e);
            }
        }
        if (this.badgeProvider == null) {
            this.badgeProvider = EmptyBadgeProvider.INSTANCE;
        }
        this.webInterfaceManager.refresh();
    }

    public WebLink getLink() {
        return this.bambooLink;
    }

    public BambooWebItemBadgeProvider getBadgeProvider() {
        return this.badgeProvider;
    }

    private static class EmptyBadgeProvider
    implements BambooWebItemBadgeProvider {
        public static EmptyBadgeProvider INSTANCE = new EmptyBadgeProvider();

        private EmptyBadgeProvider() {
        }

        @Override
        public String getBadge(Map<String, Object> context) {
            return "";
        }
    }
}

