/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.plugin.RemoteAgentSupported;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import java.io.Serializable;
import org.dom4j.Element;
import org.jetbrains.annotations.Nullable;

@RemoteAgentSupported
public class CapabilityTypeModuleDescriptor
extends AbstractBambooModuleDescriptor<CapabilityType>
implements Serializable {
    private static final String SORT_ORDER_ATTR = "sortOrder";
    private int sortOrderAttribute;

    public CapabilityTypeModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Nullable
    public String getEditTemplate() {
        return this.getFreeMarkerResourceLocation("edit");
    }

    @Nullable
    public String getViewTemplate() {
        return this.getFreeMarkerResourceLocation("view");
    }

    public int getSortOrder() {
        return this.sortOrderAttribute;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.sortOrderAttribute = Integer.parseInt(element.attributeValue(SORT_ORDER_ATTR));
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        String testNumeric = "string(number(@sortOrder)) != \"NaN\"";
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"string(number(@sortOrder)) != \"NaN\"").withError("Attribute sortOrder should be numeric")});
    }
}

