/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecoratorModuleDescriptor
extends AbstractBambooModuleDescriptor {
    private Pattern pattern;
    private String page;

    public DecoratorModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        if (element.attribute("page") == null) {
            throw new PluginParseException("No 'page' attribute specified for decorator module " + this.getName());
        }
        this.page = element.attributeValue("page");
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            if (!child.getName().equals("pattern")) continue;
            if (this.pattern != null) {
                throw new PluginParseException("Multiple patterns specified for decorator module " + this.getName());
            }
            String patternText = child.node(0).getText();
            try {
                this.pattern = Pattern.compile(patternText.replaceAll("\\*", ".*"));
            }
            catch (PatternSyntaxException pse) {
                throw new PluginParseException("Invalid pattern: " + patternText, (Throwable)pse);
            }
        }
    }

    @Nullable
    public Object getModule() {
        return null;
    }

    @Nullable
    public Pattern getPattern() {
        return this.pattern;
    }

    @NotNull
    public String getPage() {
        return this.page;
    }
}

