/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRecipientExporter;
import com.atlassian.bamboo.notification.recipients.DefaultNotificationRecipientExporter;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.WeightElementParser;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.descriptors.WeightedDescriptor;
import io.atlassian.util.concurrent.ResettableLazyReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jetbrains.annotations.Nullable;

public class NotificationRecipientModuleDescriptor
extends AbstractBambooModuleDescriptor<NotificationRecipient>
implements WeightedDescriptor {
    private static final Logger log = Logger.getLogger(NotificationRecipientModuleDescriptor.class);
    private int weight;
    private String exporterClassName;
    private ResettableLazyReference<NotificationRecipientExporter> exporter = new ResettableLazyReference<NotificationRecipientExporter>(){

        protected NotificationRecipientExporter create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)NotificationRecipientModuleDescriptor.this.exporterClassName)) {
                Class configClass = NotificationRecipientModuleDescriptor.this.plugin.loadClass(NotificationRecipientModuleDescriptor.this.exporterClassName, ((Object)((Object)this)).getClass());
                return (NotificationRecipientExporter)NotificationRecipientModuleDescriptor.this.instantiateClass(configClass);
            }
            return new DefaultNotificationRecipientExporter();
        }
    };

    public NotificationRecipientModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.weight = WeightElementParser.getWeight(element);
        this.exporterClassName = BambooPluginUtils.prepareSubModuleConfiguration(element, this.exporter, "exporter", this.getKey(), "Notification Recipient", plugin.getKey());
    }

    @Override
    protected void postInit(NotificationRecipient module) {
        module.init((WeightedDescriptor)this);
    }

    @Nullable
    public String getEditTemplate() {
        return this.getFreeMarkerResourceLocation("edit");
    }

    @Nullable
    public String getViewTemplate() {
        return this.getFreeMarkerResourceLocation("view");
    }

    public int getWeight() {
        return this.weight;
    }

    public NotificationRecipientExporter getExporter() {
        return (NotificationRecipientExporter)this.exporter.get();
    }
}

