/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.notification.DefaultNotificationTypeExporter;
import com.atlassian.bamboo.notification.NotificationType;
import com.atlassian.bamboo.notification.NotificationTypeExporter;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.WeightElementParser;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.descriptors.WeightedDescriptor;
import io.atlassian.util.concurrent.ResettableLazyReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jetbrains.annotations.Nullable;

public class NotificationTypeModuleDescriptor
extends AbstractBambooModuleDescriptor<NotificationType>
implements WeightedDescriptor {
    private static final Logger log = Logger.getLogger(NotificationTypeModuleDescriptor.class);
    private static final String EXPORTER = "exporter";
    private int weight;
    private NotificationType.Scope scope;
    private String exporterClassName;
    private ResettableLazyReference<NotificationTypeExporter> exporter = new ResettableLazyReference<NotificationTypeExporter>(){

        protected NotificationTypeExporter create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)NotificationTypeModuleDescriptor.this.exporterClassName)) {
                Class configClass = NotificationTypeModuleDescriptor.this.plugin.loadClass(NotificationTypeModuleDescriptor.this.exporterClassName, ((Object)((Object)this)).getClass());
                return (NotificationTypeExporter)NotificationTypeModuleDescriptor.this.instantiateClass(configClass);
            }
            return new DefaultNotificationTypeExporter();
        }
    };

    public NotificationTypeModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.weight = WeightElementParser.getWeight(element);
        if (element.element("scope") != null) {
            String scopeString = element.elementText("scope");
            if ("plan".equalsIgnoreCase(scopeString)) {
                this.scope = NotificationType.Scope.PLAN;
            } else if ("system".equalsIgnoreCase(scopeString)) {
                this.scope = NotificationType.Scope.SYSTEM;
            } else if ("chain".equalsIgnoreCase(scopeString)) {
                this.scope = NotificationType.Scope.CHAIN;
            } else if ("deployment".equalsIgnoreCase(scopeString)) {
                this.scope = NotificationType.Scope.DEPLOYMENT;
            } else {
                log.error((Object)("Could not determine scope of notification type " + this.getKey() + ". Notification types can only be 'system', 'plan' or 'chain'.  Defaulting to 'plan'"));
                this.scope = NotificationType.Scope.PLAN;
            }
        } else {
            this.scope = NotificationType.Scope.PLAN;
        }
        this.exporterClassName = BambooPluginUtils.prepareSubModuleConfiguration(element, this.exporter, EXPORTER, this.getKey(), "Notification Type", plugin.getKey());
    }

    @Override
    public NotificationType getModule() {
        NotificationType notificationType = (NotificationType)super.getModule();
        notificationType.init((WeightedDescriptor)this);
        return notificationType;
    }

    @Nullable
    public String getEditTemplate() {
        ResourceDescriptor resourceDescriptor = this.getResourceDescriptor("freemarker", "edit");
        return resourceDescriptor != null ? resourceDescriptor.getLocation() : null;
    }

    @Nullable
    public String getViewTemplate() {
        ResourceDescriptor resourceDescriptor = this.getResourceDescriptor("freemarker", "view");
        return resourceDescriptor != null ? resourceDescriptor.getLocation() : null;
    }

    public int getWeight() {
        return this.weight;
    }

    public NotificationType.Scope getScope() {
        return this.scope;
    }

    public NotificationTypeExporter getExporter() {
        return (NotificationTypeExporter)this.exporter.get();
    }
}

