/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.plugin.RemoteAgentSupported;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.configuration.RepositoryConfigurator;
import com.atlassian.bamboo.repository.configuration.RepositoryConfiguratorImpl;
import com.atlassian.bamboo.repository.plugin.RepositoryModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.RequiresRestart;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.spring.container.ContainerManager;
import java.io.Serializable;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RemoteAgentSupported
@RequiresRestart
public class RepositoryModuleDescriptorImpl
extends AbstractBambooModuleDescriptor<Repository>
implements RepositoryModuleDescriptor,
Serializable {
    private static final Logger log = Logger.getLogger(RepositoryModuleDescriptorImpl.class);
    public static final String REPOSITORY_PLUGIN_KEY = "com.atlassian.bamboo.plugin.system.repository";
    private RepositoryConfigurator repositoryConfigurator;

    public RepositoryModuleDescriptorImpl(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        String stringIsPrimary = element.attributeValue("primary");
        String stringWeight = element.attributeValue("weight");
        boolean isPrimary = Boolean.parseBoolean(stringIsPrimary);
        int weight = NumberUtils.toInt((String)stringWeight, (int)Integer.MAX_VALUE);
        String icon = this.getElementAsString(element.element("icon"));
        String tooltipKey = this.getElementAsString(element.element("tooltipKey"));
        this.repositoryConfigurator = new RepositoryConfiguratorImpl(weight, isPrimary, icon, tooltipKey);
    }

    @Override
    public Repository getModule() {
        Repository module = (Repository)super.getModule();
        if (AgentTypeHolder.get() != AgentType.LOCAL && module != null) {
            ContainerManager.autowireComponent((Object)module);
        }
        return module;
    }

    @Nullable
    public String getEditTemplate() {
        return this.getFreeMarkerResourceLocation("edit");
    }

    @Nullable
    public String getAdvancedEditTemplate() {
        return this.getFreeMarkerResourceLocation("advancedEdit");
    }

    @Nullable
    public String getAdvancedViewTemplate() {
        return this.getFreeMarkerResourceLocation("advancedView");
    }

    @Nullable
    public String getViewTemplate() {
        return this.getFreeMarkerResourceLocation("view");
    }

    @Nullable
    public String getChangeDetectionEditTemplate() {
        String template = this.getFreeMarkerResourceLocation("changeDetectionEdit");
        return template != null ? template : this.getEditTemplate();
    }

    @Nullable
    public String getChangeDetectionViewTemplate() {
        String template = this.getFreeMarkerResourceLocation("changeDetectionView");
        return template != null ? template : this.getViewTemplate();
    }

    @Nullable
    public String getMinimalEditTemplate() {
        String template = this.getFreeMarkerResourceLocation("minimalEdit");
        return template != null ? template : this.getEditTemplate();
    }

    @Nullable
    public String getMavenPomCheckoutAccessEditTemplate() {
        String template = this.getFreeMarkerResourceLocation("mavenPomCheckoutAccessEdit");
        return template != null ? template : this.getMinimalEditTemplate();
    }

    @Nullable
    public String getBranchIntegrationEditTemplate() {
        return this.getFreeMarkerResourceLocation("branchIntegrationEdit");
    }

    @NotNull
    public RepositoryConfigurator getConfigurator() {
        return this.repositoryConfigurator;
    }
}

