/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.CannotDisable;
import com.atlassian.plugin.descriptors.RequiresRestart;
import com.atlassian.plugin.module.ModuleFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

@RequiresRestart
@CannotDisable
public class SpringComponentModuleDescriptor
extends AbstractBambooModuleDescriptor<Object>
implements BeanFactoryAware {
    private static final Logger log = Logger.getLogger(SpringComponentModuleDescriptor.class);
    private BeanFactory beanFactory;
    private String alias;

    public SpringComponentModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.alias = element.attributeValue("alias");
    }

    public void enabled() {
        super.enabled();
        this.checkThatBeanDoesNotExist();
        String beanName = this.getBeanName();
        Object bean = this.getModule();
        this.getSingletonBeanRegistry().registerSingleton(beanName, bean);
    }

    @Override
    protected boolean isMutable() {
        return false;
    }

    private String checkThatBeanDoesNotExist() {
        String beanName = this.getBeanName();
        if (this.beanFactory.containsBean(beanName)) {
            throw new PluginParseException("Bean with name '" + this.getKey() + "' already exists in container");
        }
        return beanName;
    }

    private SingletonBeanRegistry getSingletonBeanRegistry() {
        this.checkTypes();
        return (SingletonBeanRegistry)this.beanFactory;
    }

    private BeanDefinitionRegistry getBeanDefinitionRegistry() {
        this.checkTypes();
        return (BeanDefinitionRegistry)this.beanFactory;
    }

    private void checkTypes() {
        if (!(this.beanFactory instanceof SingletonBeanRegistry)) {
            throw new PluginParseException("Cannot register/unregister component with spring because bean factory is not type of " + SingletonBeanRegistry.class + " but was " + this.beanFactory.getClass());
        }
        if (!(this.beanFactory instanceof BeanDefinitionRegistry)) {
            throw new PluginParseException("Cannot register/unregister component with spring because bean factory is not type of " + BeanDefinitionRegistry.class + " but was " + this.beanFactory.getClass());
        }
    }

    private String getBeanName() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.alias, (CharSequence)this.getKey());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

