/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.RemoteAgentSupported;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.TaskHelpLinkImpl;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.task.InternalTaskType;
import com.atlassian.bamboo.task.RuntimeTaskDataProvider;
import com.atlassian.bamboo.task.TaskCategory;
import com.atlassian.bamboo.task.TaskConfigurator;
import com.atlassian.bamboo.task.TaskExecutableType;
import com.atlassian.bamboo.task.TaskExecutableTypeImpl;
import com.atlassian.bamboo.task.TaskHelpLink;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.background.TaskBackgroundProcessor;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.Dom4jUtils;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RemoteAgentSupported
public final class TaskModuleDescriptorImpl
extends AbstractBambooModuleDescriptor<InternalTaskType>
implements TaskModuleDescriptor,
Serializable {
    private static final Logger log = Logger.getLogger(TaskModuleDescriptorImpl.class);
    private static final String CONFIGURATION = "configuration";
    private static final String EXPORTER = "exporter";
    private static final String CAPABILITY_DEFAULTS_HELPER = "capabilityDefaultsHelper";
    private static final String RUNTIME_TASK_DATA_PROVIDER = "runtimeTaskDataProvider";
    private static final String TASK_BACKGROUND_PROCESSOR = "taskBackgroundProcessor";
    private static final String ICON_RESOURCE = "icon";
    private static final String ICON_2X_RESOURCE = "icon@2x";
    private static final String DOWNLOAD_RESOURCE_TYPE = "download";
    private List<TaskCategory> categories = new ArrayList<TaskCategory>();
    private List<TaskExecutableType> taskExecutables = new ArrayList<TaskExecutableType>();
    private String configClazz;
    private String exporterClassName;
    private String capabilityDefaultsHelperClazz;
    private String runtimeTaskDataProviderClazz;
    private String taskBackgroundProcessorClazz;
    private TaskHelpLink helpLink;
    private transient ResettableLazyReference<TaskConfigurator> configurator = new ResettableLazyReference<TaskConfigurator>(){

        protected TaskConfigurator create() throws Exception {
            if (StringUtils.isBlank((CharSequence)TaskModuleDescriptorImpl.this.configClazz)) {
                return null;
            }
            Class configClass = TaskModuleDescriptorImpl.this.plugin.loadClass(TaskModuleDescriptorImpl.this.configClazz, ((Object)((Object)this)).getClass());
            return (TaskConfigurator)TaskModuleDescriptorImpl.this.instantiateClass(configClass);
        }
    };
    private transient ResettableLazyReference<CapabilityDefaultsHelper> capabilityDefaultsHelper = new ResettableLazyReference<CapabilityDefaultsHelper>(){

        protected CapabilityDefaultsHelper create() throws Exception {
            if (StringUtils.isBlank((CharSequence)TaskModuleDescriptorImpl.this.capabilityDefaultsHelperClazz)) {
                return null;
            }
            Class capabilityDefaultsHelperClass = TaskModuleDescriptorImpl.this.plugin.loadClass(TaskModuleDescriptorImpl.this.capabilityDefaultsHelperClazz, ((Object)((Object)this)).getClass());
            return (CapabilityDefaultsHelper)TaskModuleDescriptorImpl.this.instantiateClass(capabilityDefaultsHelperClass);
        }
    };
    private transient ResettableLazyReference<RuntimeTaskDataProvider> runtimeTaskDataProvider = new ResettableLazyReference<RuntimeTaskDataProvider>(){

        protected RuntimeTaskDataProvider create() throws Exception {
            if (StringUtils.isBlank((CharSequence)TaskModuleDescriptorImpl.this.runtimeTaskDataProviderClazz)) {
                return null;
            }
            Class capabilityDefaultsHelperClass = TaskModuleDescriptorImpl.this.plugin.loadClass(TaskModuleDescriptorImpl.this.runtimeTaskDataProviderClazz, ((Object)((Object)this)).getClass());
            return (RuntimeTaskDataProvider)TaskModuleDescriptorImpl.this.instantiateClass(capabilityDefaultsHelperClass);
        }
    };
    private transient ResettableLazyReference<TaskBackgroundProcessor> taskBackgroundProcessor = new ResettableLazyReference<TaskBackgroundProcessor>(){

        protected TaskBackgroundProcessor create() throws Exception {
            if (StringUtils.isBlank((CharSequence)TaskModuleDescriptorImpl.this.taskBackgroundProcessorClazz)) {
                return null;
            }
            Class capabilityDefaultsHelperClass = TaskModuleDescriptorImpl.this.plugin.loadClass(TaskModuleDescriptorImpl.this.taskBackgroundProcessorClazz, ((Object)((Object)this)).getClass());
            return (TaskBackgroundProcessor)TaskModuleDescriptorImpl.this.instantiateClass(capabilityDefaultsHelperClass);
        }
    };
    private ResettableLazyReference<TaskDefinitionExporter> exporter = new ResettableLazyReference<TaskDefinitionExporter>(){

        protected TaskDefinitionExporter create() throws Exception {
            if (StringUtils.isBlank((CharSequence)TaskModuleDescriptorImpl.this.exporterClassName)) {
                return null;
            }
            Class configClass = TaskModuleDescriptorImpl.this.plugin.loadClass(TaskModuleDescriptorImpl.this.exporterClassName, ((Object)((Object)this)).getClass());
            return (TaskDefinitionExporter)TaskModuleDescriptorImpl.this.instantiateClass(configClass);
        }
    };

    public TaskModuleDescriptorImpl(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.configClazz = BambooPluginUtils.prepareSubModuleConfiguration(element, this.configurator, CONFIGURATION, this.getKey(), "Task Type", plugin.getKey());
        this.capabilityDefaultsHelperClazz = BambooPluginUtils.prepareSubModuleConfiguration(element, this.capabilityDefaultsHelper, CAPABILITY_DEFAULTS_HELPER, this.getKey(), "Task Type", plugin.getKey());
        this.runtimeTaskDataProviderClazz = BambooPluginUtils.prepareSubModuleConfiguration(element, this.runtimeTaskDataProvider, RUNTIME_TASK_DATA_PROVIDER, this.getKey(), "Task Type", plugin.getKey());
        this.exporterClassName = BambooPluginUtils.prepareSubModuleConfiguration(element, this.exporter, EXPORTER, this.getKey(), "Task Type", plugin.getKey());
        this.taskBackgroundProcessorClazz = BambooPluginUtils.prepareSubModuleConfiguration(element, this.taskBackgroundProcessor, TASK_BACKGROUND_PROCESSOR, this.getKey(), "Task Type", plugin.getKey());
        this.initialiseTaskCategories(plugin, element);
        this.initialiseTaskExecutables(plugin, element);
        this.initialiseTaskHelp(plugin, element);
    }

    @Override
    public void disabled() {
        super.disabled();
        this.configurator.reset();
        this.capabilityDefaultsHelper.reset();
        this.runtimeTaskDataProvider.reset();
        this.taskBackgroundProcessor.reset();
        this.exporter.reset();
    }

    private void initialiseTaskExecutables(Plugin plugin, Element element) {
        List<Element> executableElements = Dom4jUtils.elements(element, "executable");
        if (executableElements.isEmpty()) {
            return;
        }
        for (Element executableElement : executableElements) {
            Attribute key = executableElement.attribute("key");
            if (key != null && StringUtils.isNotEmpty((CharSequence)key.getValue())) {
                Attribute nameKey = executableElement.attribute("nameKey");
                Attribute pathHelpKey = executableElement.attribute("pathHelpKey");
                Attribute primaryCapabilityProvider = executableElement.attribute("primaryCapabilityProvider");
                this.taskExecutables.add(new TaskExecutableTypeImpl(key, nameKey, pathHelpKey, primaryCapabilityProvider));
                continue;
            }
            log.warn((Object)("Task Type Module (" + this.getKey() + ") of plugin " + plugin.getKey() + " contains an incorrectly configured 'executable' element. Please use the 'key' attribute to define your unique executable key"));
        }
    }

    public CapabilityDefaultsHelper getCapabilityDefaultsHelper() {
        return (CapabilityDefaultsHelper)this.capabilityDefaultsHelper.get();
    }

    @Nullable
    public TaskConfigurator getTaskConfigurator() {
        if (AgentTypeHolder.get() == AgentType.LOCAL || !BuildUtils.isDevMode()) {
            return (TaskConfigurator)this.configurator.get();
        }
        throw new UnsupportedOperationException("Cannot access task configurator on remote agents");
    }

    @NotNull
    public List<TaskCategory> getCategories() {
        return this.categories;
    }

    @NotNull
    public List<TaskExecutableType> getTaskExecutables() {
        return this.taskExecutables;
    }

    @Nullable
    public String getIconUrl() {
        return this.getIconUrl(ICON_RESOURCE);
    }

    @Nullable
    public String getIcon2xUrl() {
        return this.getIconUrl(ICON_2X_RESOURCE);
    }

    @Nullable
    private String getIconUrl(@NotNull String resourceName) {
        WebResourceUrlProvider webResourceUrlProvider = (WebResourceUrlProvider)ComponentAccessor.WEB_RESOURCE_URL_PROVIDER.get();
        if (webResourceUrlProvider != null && this.getResourceDescriptor(DOWNLOAD_RESOURCE_TYPE, resourceName) != null) {
            return webResourceUrlProvider.getStaticPluginResourceUrl((ModuleDescriptor)this, resourceName, UrlMode.RELATIVE);
        }
        return null;
    }

    @Nullable
    public TaskHelpLink getHelpLink() {
        return this.helpLink;
    }

    @Nullable
    public RuntimeTaskDataProvider getRuntimeTaskDataProvider() {
        RuntimeTaskDataProvider taskDataProvider = (RuntimeTaskDataProvider)this.runtimeTaskDataProvider.get();
        if (taskDataProvider != null) {
            ContainerManager.autowireComponent((Object)taskDataProvider);
        }
        return taskDataProvider;
    }

    @Nullable
    public TaskBackgroundProcessor getTaskBackgroundProcessor() {
        return (TaskBackgroundProcessor)this.taskBackgroundProcessor.get();
    }

    @NotNull
    public TaskDefinitionExporter getTaskExporter() {
        return (TaskDefinitionExporter)this.exporter.get();
    }

    private void initialiseTaskCategories(Plugin plugin, Element element) {
        List<Element> categoryElements = Dom4jUtils.elements(element, "category");
        for (Element categoryElement : categoryElements) {
            String categoryStr = StringUtils.defaultString((String)categoryElement.attributeValue("name"));
            try {
                this.categories.add(TaskCategory.valueOf((String)categoryStr.toUpperCase()));
            }
            catch (IllegalArgumentException ignored) {
                log.warn((Object)("Category definition for Task Type " + this.getKey() + " of plugin " + plugin.getKey() + " is not valid.  No such category as: [" + categoryStr + ']'));
            }
        }
    }

    private void initialiseTaskHelp(Plugin plugin, Element element) {
        Element helpElement = element.element("help");
        if (helpElement != null) {
            Attribute helpTitleAttr = helpElement.attribute("title");
            Attribute helpUrlAttr = helpElement.attribute("link");
            Attribute helpKeyAttr = helpElement.attribute("key");
            String helpTitle = TaskModuleDescriptorImpl.getAttributeValueSafely(helpTitleAttr);
            String helpUrl = TaskModuleDescriptorImpl.getAttributeValueSafely(helpUrlAttr);
            String helpKey = TaskModuleDescriptorImpl.getAttributeValueSafely(helpKeyAttr);
            if (StringUtils.isNotBlank((CharSequence)helpKey)) {
                this.helpLink = new TaskHelpLinkImpl(helpKey, null, null, true);
            } else if (StringUtils.isNotBlank((CharSequence)helpUrl) && StringUtils.isNotBlank((CharSequence)helpTitle)) {
                this.helpLink = new TaskHelpLinkImpl(null, helpUrl, helpTitle, false);
            } else {
                log.warn((Object)("Help definition for Task Type " + this.getKey() + " of plugin " + plugin.getKey() + " is not valid. It must contain either a 'key' attribute, or both 'title' and 'link' attributes."));
                this.helpLink = null;
            }
        }
    }

    static String getAttributeValueSafely(@Nullable Attribute attribute) {
        return attribute != null ? attribute.getValue() : null;
    }
}

