/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.plugin.RemoteAgentSupported;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.task.TaskProcessCommandDecoratorModuleDescriptor;
import com.atlassian.bamboo.task.plugins.TaskProcessCommandDecorator;
import com.atlassian.bamboo.utils.Dom4jUtils;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;

@RemoteAgentSupported
public final class TaskProcessCommandDecoratorModuleDescriptorImpl
extends AbstractBambooModuleDescriptor<TaskProcessCommandDecorator>
implements TaskProcessCommandDecoratorModuleDescriptor,
Serializable {
    private static final String ELEM_DECORATED_TASK_TYPE = "decoratedTaskType";
    private static final String ATTR_DECORATED_TASK_TYPE_KEY = "key";
    private final Set<Pair<String, String>> undecoratedTaskTypeSplitKeys = new HashSet<Pair<String, String>>();
    private final Set<Pair<String, String>> decoratedTaskTypeSplitKeys = new HashSet<Pair<String, String>>();
    private final Set<String> decoratedTaskTypeKeys = new HashSet<String>();

    public TaskProcessCommandDecoratorModuleDescriptorImpl(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        for (Element e : Dom4jUtils.elements(element, ELEM_DECORATED_TASK_TYPE)) {
            Set<Pair<String, String>> taskTypeKeys;
            String key = e.attributeValue(ATTR_DECORATED_TASK_TYPE_KEY);
            if (key.startsWith("!")) {
                taskTypeKeys = this.undecoratedTaskTypeSplitKeys;
                key = StringUtils.substringAfter((String)key, (String)"!");
            } else {
                taskTypeKeys = this.decoratedTaskTypeSplitKeys;
            }
            if (!key.contains(":")) {
                key = plugin.getKey() + ":" + key;
            }
            taskTypeKeys.add((Pair<String, String>)Pair.of((Object)StringUtils.substringBefore((String)key, (String)":"), (Object)StringUtils.substringAfter((String)key, (String)":")));
            this.decoratedTaskTypeKeys.add(key);
        }
    }

    @NotNull
    public Set<String> getDecorableTaskTypeKeys() {
        return this.decoratedTaskTypeKeys;
    }

    public boolean isApplicableToTaskType(@NotNull String testedPluginModuleKey) {
        for (Pair<String, String> taskTypeKey : this.undecoratedTaskTypeSplitKeys) {
            if (!this.isMatching(testedPluginModuleKey, taskTypeKey)) continue;
            return false;
        }
        for (Pair<String, String> taskTypeKey : this.decoratedTaskTypeSplitKeys) {
            if (!this.isMatching(testedPluginModuleKey, taskTypeKey)) continue;
            return true;
        }
        return this.decoratedTaskTypeSplitKeys.isEmpty();
    }

    private boolean isMatching(@NotNull String testedPluginModuleKey, Pair<String, String> decoratedTaskTypeKey) {
        String decoratedPluginKey = (String)decoratedTaskTypeKey.getKey();
        String decoratedModuleKey = (String)decoratedTaskTypeKey.getValue();
        boolean isPluginKeyMatching = decoratedPluginKey.equals("*") || testedPluginModuleKey.startsWith(decoratedPluginKey + ":");
        boolean isModuleKeyMatching = decoratedModuleKey.equals("*") || testedPluginModuleKey.endsWith(":" + decoratedModuleKey);
        return isPluginKeyMatching && isModuleKeyMatching;
    }
}

