/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.descriptor;

import com.atlassian.bamboo.ServerLifecycleManager;
import com.atlassian.bamboo.ServerLifecycleState;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.trigger.TriggerActivator;
import com.atlassian.bamboo.trigger.TriggerConfigurator;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.trigger.applicability.CanTriggerAnything;
import com.atlassian.bamboo.trigger.applicability.TriggerApplicabilityCondition;
import com.atlassian.bamboo.trigger.export.TriggerDefinitionExporter;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TriggerModuleDescriptorImpl
extends AbstractBambooModuleDescriptor<TriggerActivator>
implements TriggerModuleDescriptor,
Serializable {
    private static final Logger log = Logger.getLogger(TriggerModuleDescriptorImpl.class);
    private static final String CONFIGURATOR = "configurator";
    private static final String EXPORTER = "exporter";
    private static final String APPLICABILITY = "applicability";
    private static final String ICON_RESOURCE = "icon";
    private static final String DOWNLOAD_RESOURCE_TYPE = "download";
    private String configuratorClassName;
    private String exporterClassName;
    private String applicabilityConditionClassName;
    private boolean requiresChangeDetectionOnCompletion;
    private ResettableLazyReference<TriggerConfigurator> configurator = new ResettableLazyReference<TriggerConfigurator>(){

        protected TriggerConfigurator create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)TriggerModuleDescriptorImpl.this.configuratorClassName)) {
                Class configClass = TriggerModuleDescriptorImpl.this.plugin.loadClass(TriggerModuleDescriptorImpl.this.configuratorClassName, ((Object)((Object)this)).getClass());
                return (TriggerConfigurator)TriggerModuleDescriptorImpl.this.instantiateClass(configClass);
            }
            return null;
        }
    };
    private ResettableLazyReference<TriggerApplicabilityCondition> applicabilityCondition = new ResettableLazyReference<TriggerApplicabilityCondition>(){

        protected TriggerApplicabilityCondition create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)TriggerModuleDescriptorImpl.this.applicabilityConditionClassName)) {
                Class configClass = TriggerModuleDescriptorImpl.this.plugin.loadClass(TriggerModuleDescriptorImpl.this.applicabilityConditionClassName, ((Object)((Object)this)).getClass());
                return (TriggerApplicabilityCondition)TriggerModuleDescriptorImpl.this.instantiateClass(configClass);
            }
            return (TriggerApplicabilityCondition)TriggerModuleDescriptorImpl.this.instantiateClass(CanTriggerAnything.class);
        }
    };
    private ResettableLazyReference<TriggerDefinitionExporter> exporter = new ResettableLazyReference<TriggerDefinitionExporter>(){

        protected TriggerDefinitionExporter create() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)TriggerModuleDescriptorImpl.this.exporterClassName)) {
                Class configClass = TriggerModuleDescriptorImpl.this.plugin.loadClass(TriggerModuleDescriptorImpl.this.exporterClassName, ((Object)((Object)this)).getClass());
                return (TriggerDefinitionExporter)TriggerModuleDescriptorImpl.this.instantiateClass(configClass);
            }
            return null;
        }
    };

    public TriggerModuleDescriptorImpl(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.configuratorClassName = BambooPluginUtils.prepareSubModuleConfiguration(element, this.configurator, CONFIGURATOR, this.getKey(), "Trigger Type", plugin.getKey());
        this.exporterClassName = BambooPluginUtils.prepareSubModuleConfiguration(element, this.exporter, EXPORTER, this.getKey(), "Trigger Type", plugin.getKey());
        this.applicabilityConditionClassName = BambooPluginUtils.prepareSubModuleConfiguration(element, this.applicabilityCondition, APPLICABILITY, this.getKey(), "Trigger Type", plugin.getKey());
        this.requiresChangeDetectionOnCompletion = Boolean.valueOf(element.attributeValue("detectChangesOnCompletion"));
    }

    @Override
    protected boolean isMutable() {
        return false;
    }

    private void activateDeactivate(Op op) {
        CachedPlanManager planManager = (CachedPlanManager)ComponentAccessor.CACHED_PLAN_MANAGER.get();
        EnvironmentService environmentService = (EnvironmentService)ComponentAccessor.ENVIRONMENT_SERVICE.get();
        for (Triggerable triggerable : Iterables.concat((Iterable)planManager.getPlansUnrestricted(), (Iterable)environmentService.getAllEnvironmentsNoUserContext())) {
            for (TriggerDefinition triggerDefinition : triggerable.getTriggerDefinitions()) {
                if (!this.getCompleteKey().equals(triggerDefinition.getPluginKey())) continue;
                TriggerActivator triggerActivator = (TriggerActivator)this.getModule();
                if (triggerActivator != null) {
                    try {
                        if (op == Op.ACTIVATE && triggerDefinition.isEnabled()) {
                            triggerActivator.initAndActivate(triggerable, triggerDefinition, null);
                            continue;
                        }
                        triggerActivator.deactivate(triggerable, triggerDefinition);
                    }
                    catch (Exception e) {
                        log.warn((Object)("could not " + op.name().toLowerCase() + " trigger " + triggerDefinition.getName() + " " + triggerDefinition.getUserDescription()), (Throwable)e);
                    }
                    continue;
                }
                log.warn((Object)("could not " + op.name().toLowerCase() + " trigger " + triggerDefinition.getName() + " " + triggerDefinition.getUserDescription()));
            }
        }
    }

    @Override
    public void disabled() {
        log.debug((Object)("tearing down triggers of type: " + this.getCompleteKey()));
        this.activateDeactivate(Op.DEACTIVATE);
        this.applicabilityCondition.reset();
        this.configurator.reset();
        this.exporter.reset();
        super.disabled();
    }

    public void enabled() {
        super.enabled();
        this.applicabilityCondition.reset();
        this.configurator.reset();
        this.exporter.reset();
        if (((ServerLifecycleManager)ComponentAccessor.SERVER_LIFECYCLE_MANAGER.get()).getServerLifecycleState() != ServerLifecycleState.RUNNING) {
            return;
        }
        log.debug((Object)("setting up triggers of type: " + this.getCompleteKey()));
        this.activateDeactivate(Op.ACTIVATE);
    }

    @Nullable
    public String getIconUrl() {
        WebResourceUrlProvider webResourceUrlProvider = (WebResourceUrlProvider)ComponentAccessor.WEB_RESOURCE_URL_PROVIDER.get();
        if (webResourceUrlProvider != null && this.getResourceDescriptor(DOWNLOAD_RESOURCE_TYPE, ICON_RESOURCE) != null) {
            return webResourceUrlProvider.getStaticPluginResourceUrl((ModuleDescriptor)this, ICON_RESOURCE, UrlMode.RELATIVE);
        }
        return null;
    }

    public boolean canTrigger(@NotNull Triggerable triggerable) {
        return ((TriggerApplicabilityCondition)this.applicabilityCondition.get()).canTrigger(triggerable);
    }

    public boolean canTriggerType(@NotNull Class<? extends Triggerable> triggerableType) {
        return ((TriggerApplicabilityCondition)this.applicabilityCondition.get()).canTriggerType(triggerableType);
    }

    public boolean requiresChangeDetectionOnCompletion() {
        return this.requiresChangeDetectionOnCompletion;
    }

    @Nullable
    public TriggerConfigurator getTriggerConfigurator() {
        return (TriggerConfigurator)this.configurator.get();
    }

    @Nullable
    public TriggerDefinitionExporter getTriggerExporter() {
        return (TriggerDefinitionExporter)this.exporter.get();
    }

    private static enum Op {
        ACTIVATE,
        DEACTIVATE;

    }
}

