/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.events;

import com.atlassian.bamboo.plugin.AgentPluginResolver;
import com.atlassian.bamboo.plugin.PluginIdentifier;
import com.atlassian.bamboo.plugin.PluginModuleIdentifier;
import com.atlassian.bamboo.plugin.events.DisableRemotePluginEvent;
import com.atlassian.bamboo.plugin.events.DisableRemotePluginModuleEvent;
import com.atlassian.bamboo.plugin.events.EnableRemotePluginEvent;
import com.atlassian.bamboo.plugin.events.EnableRemotePluginModuleEvent;
import com.atlassian.bamboo.plugin.events.UninstallRemotePluginEvent;
import com.atlassian.bamboo.plugin.events.UpgradeRemotePluginEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.InitializingBean;

public class RemoteAgentPluginEventForwarder
implements InitializingBean {
    private static final Logger log = Logger.getLogger(RemoteAgentPluginEventForwarder.class);
    private final EventPublisher eventPublisher;
    private final PluginEventManager pluginEventManager;
    private final AgentPluginResolver agentPluginResolver;

    public RemoteAgentPluginEventForwarder(EventPublisher eventPublisher, PluginEventManager pluginEventManager, AgentPluginResolver agentPluginResolver) {
        this.eventPublisher = eventPublisher;
        this.pluginEventManager = pluginEventManager;
        this.agentPluginResolver = agentPluginResolver;
    }

    public void afterPropertiesSet() throws Exception {
        this.pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void pluginUninstalled(@NotNull PluginUninstalledEvent pluginUninstalledEvent) {
        Plugin plugin = pluginUninstalledEvent.getPlugin();
        if (this.agentPluginResolver.matches(plugin, AgentPluginResolver.AgentPluginFilter.newFilter())) {
            PluginIdentifier pluginIdentifier = new PluginIdentifier(plugin);
            this.eventPublisher.publish((Object)new UninstallRemotePluginEvent(pluginIdentifier));
        }
    }

    @PluginEventListener
    public void pluginUpgraded(@NotNull PluginUpgradedEvent pluginUpgradedEvent) {
        Plugin plugin = pluginUpgradedEvent.getPlugin();
        if (this.agentPluginResolver.matches(plugin, AgentPluginResolver.AgentPluginFilter.newFilter().setNonBundledOnly())) {
            PluginIdentifier pluginIdentifier = new PluginIdentifier(plugin);
            this.eventPublisher.publish((Object)new UpgradeRemotePluginEvent(pluginIdentifier));
        }
    }

    @PluginEventListener
    public void pluginEnabled(@NotNull PluginEnabledEvent pluginEnabledEvent) {
        Plugin plugin = pluginEnabledEvent.getPlugin();
        if (this.agentPluginResolver.matches(plugin, AgentPluginResolver.AgentPluginFilter.newFilter())) {
            PluginIdentifier pluginIdentifier = new PluginIdentifier(plugin);
            this.eventPublisher.publish((Object)new EnableRemotePluginEvent(pluginIdentifier));
        }
    }

    @PluginEventListener
    public void pluginDisabled(@NotNull PluginDisabledEvent pluginDisabledEvent) {
        Plugin plugin = pluginDisabledEvent.getPlugin();
        if (this.agentPluginResolver.matches(plugin, AgentPluginResolver.AgentPluginFilter.newFilter())) {
            PluginIdentifier pluginIdentifier = new PluginIdentifier(plugin);
            this.eventPublisher.publish((Object)new DisableRemotePluginEvent(pluginIdentifier));
        }
    }

    @PluginEventListener
    public void pluginModuleEnabled(@NotNull PluginModuleEnabledEvent pluginModuleEnabledEvent) {
        PluginModuleIdentifier pluginModuleIdentifier = new PluginModuleIdentifier(pluginModuleEnabledEvent.getModule());
        if (this.agentPluginResolver.matches(pluginModuleEnabledEvent.getModule().getPlugin(), AgentPluginResolver.AgentPluginFilter.newFilter().setEnabledOnly())) {
            this.eventPublisher.publish((Object)new EnableRemotePluginModuleEvent(pluginModuleIdentifier));
        }
    }

    @PluginEventListener
    public void pluginModuleDisabled(@NotNull PluginModuleDisabledEvent pluginModuleDisabledEvent) {
        PluginModuleIdentifier pluginModuleIdentifier = new PluginModuleIdentifier(pluginModuleDisabledEvent.getModule());
        if (this.agentPluginResolver.matches(pluginModuleDisabledEvent.getModule().getPlugin(), AgentPluginResolver.AgentPluginFilter.newFilter().setEnabledOnly()) && pluginModuleDisabledEvent.isPersistent()) {
            this.eventPublisher.publish((Object)new DisableRemotePluginModuleEvent(pluginModuleIdentifier));
        }
    }
}

