/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.loaders;

import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.DirectoryScanner;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.ScanningPluginLoader;
import com.atlassian.plugin.loaders.classloading.Scanner;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class DirectoryScanningPluginFactory
implements FactoryBean {
    private static final Logger log = LoggerFactory.getLogger(DirectoryScanningPluginFactory.class);
    private final ScanningPluginLoader scanningPluginLoader;

    public DirectoryScanningPluginFactory(List<PluginFactory> pluginFactories, PluginEventManager eventManager) {
        SystemProperty systemProperty = SystemProperty.DIRECTORY_SCANNING_PLUGIN_SCAN_DIR;
        String directoryName = systemProperty.getValue();
        if (directoryName == null) {
            log.debug("The system property {} is undefined.", (Object)systemProperty.getKey());
            this.scanningPluginLoader = null;
            return;
        }
        File directory = new File(directoryName);
        if (!directory.isDirectory() || !directory.canRead()) {
            log.error("The path {} isn't a readable directory.", (Object)directoryName);
            this.scanningPluginLoader = null;
            return;
        }
        log.debug("Loading additional plugins from {}.", (Object)directoryName);
        DirectoryScanner scanner = new DirectoryScanner(directory);
        this.scanningPluginLoader = new ScanningPluginLoader((Scanner)scanner, pluginFactories, eventManager);
    }

    public Object getObject() {
        return this.scanningPluginLoader;
    }

    public Class getObjectType() {
        return PluginLoader.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

