/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.loaders;

import com.atlassian.bamboo.plugin.loaders.BundledPluginsAccessor;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.plugin.servlet.ServletContextFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerBundledPluginsAccessor
implements BundledPluginsAccessor {
    private static final Logger log = Logger.getLogger(ServerBundledPluginsAccessor.class);
    private static final String PROPERTY_DEV_BUNDLED_PLUGINS_URL = "bamboo.dev.bundledplugins.url";
    private static final String BUNDLED_PLUGIN_LOCATION = "/WEB-INF/atlassian-bundled-plugins";
    private final ServletContextFactory servletContextFactory;

    public ServerBundledPluginsAccessor(ServletContextFactory servletContextFactory) {
        this.servletContextFactory = servletContextFactory;
    }

    @NotNull
    public File getBundledPluginsLocation() {
        File customBundledPluginsLocation = this.getCustomBundledPluginsLocation();
        if (BuildUtils.isDevMode() && customBundledPluginsLocation != null) {
            log.info((Object)("DEV MODE: loading bundled plugins from: [" + customBundledPluginsLocation + ']'));
            return customBundledPluginsLocation;
        }
        String bundledPluginsLocation = this.servletContextFactory.getServletContext().getRealPath(BUNDLED_PLUGIN_LOCATION);
        if (bundledPluginsLocation != null) {
            return new File(bundledPluginsLocation);
        }
        log.error((Object)"Cannot load bundled plugins: neither /WEB-INF/atlassian-bundled-plugins nor the list file has been found. Falling back to classloader - this may increase memory consumption");
        log.error((Object)"Unable to load bundled plugins. Tried: custom URL, servlet container path.");
        log.error((Object)"Note: running Bamboo from a packed WAR is not supported. Configure your Servlet container to unpack the WAR before running it.");
        throw new IllegalStateException("Unable to load bundled plugins");
    }

    @Nullable
    private File getCustomBundledPluginsLocation() {
        URI customBundledPluginsUrl = this.getCustomBundledPluginsUrl();
        if (customBundledPluginsUrl == null) {
            return null;
        }
        return new File(customBundledPluginsUrl);
    }

    @Nullable
    private URI getCustomBundledPluginsUrl() {
        String url = System.getProperty(PROPERTY_DEV_BUNDLED_PLUGINS_URL);
        if (url == null) {
            return null;
        }
        try {
            return new URL(url).toURI();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Can't form url to bundled plugins file [" + url + ']', e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Can't form url to bundled plugins file [" + url + ']', e);
        }
    }
}

