/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.osgi;

import com.atlassian.bamboo.plugin.osgi.FrameworkBundlesDirectoryAccessor;
import java.io.File;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.ServletContextAware;

public class FrameworkBundlesDirectoryAccessorImpl
implements FrameworkBundlesDirectoryAccessor,
ServletContextAware {
    private static final String PLUGIN_FRAMEWORK_BUNDLES_PROPERTY = "framework.bundles";
    private static final String PLUGIN_FRAMEWORK_BUNDLES_SUB_DIR = "framework-bundles";
    private static final String DEV_MODE_PATH_SRC = "components/bamboo-web-app/src/main/webapp/WEB-INF/";
    private static final String DEV_MODE_PATH_TARGET = "components/bamboo-web-app/src/main/webapp/WEB-INF/".replace("/src/main/webapp", "/target/atlassian-bamboo-web-app");
    private ServletContext servletContext;

    public File getFrameworkBundlesDirectory() {
        return this.findAndCreateDirectory(this.servletContext, PLUGIN_FRAMEWORK_BUNDLES_PROPERTY, "/WEB-INF/framework-bundles");
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private File findAndCreateDirectory(ServletContext servletContext, String sysPropName, String path) {
        String frameWorkBundleLocation = System.getProperty(sysPropName);
        if (frameWorkBundleLocation == null) {
            String fsPath = servletContext.getRealPath(path);
            frameWorkBundleLocation = StringUtils.replace((String)fsPath, (String)DEV_MODE_PATH_SRC, (String)DEV_MODE_PATH_TARGET);
        }
        return this.ensureExistingDirectory(new File(frameWorkBundleLocation));
    }

    private File ensureExistingDirectory(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Could not create directory [" + dir + ']');
        }
        return dir;
    }
}

