/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.osgi;

import com.atlassian.bamboo.agent.classserver.JarDescriptor;
import com.atlassian.bamboo.io.FileInputSupplier;
import com.atlassian.bamboo.plugin.osgi.FrameworkBundlesResolver;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;

public class FrameworkBundlesResolverImpl
implements FrameworkBundlesResolver {
    private static final FileFilter BUNDLE_FILTER = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter()});
    @Inject
    @Qualifier(value="frameworkBundlesDirectory")
    private File frameworkBundlesDirectory;

    @NotNull
    public List<JarDescriptor> getFrameworkBundles() {
        File[] files = this.frameworkBundlesDirectory.listFiles(BUNDLE_FILTER);
        if (files != null) {
            return Arrays.stream(files).map(f -> new JarDescriptor(f, (InputSupplier)new FileInputSupplier((File)f))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

