/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.osgi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;

final class InvocationHandlers {
    private InvocationHandlers() {
    }

    public static <T> InvocationHandler classLoaderSwitchingInvocationHandler(Class<T> clazz, Supplier<T> serviceAccessor) {
        return new ClassLoaderSwitchingInvocationHandler<T>(clazz, serviceAccessor);
    }

    public static <T> InvocationHandler nonIsolatingClassLoaderInvocationHandler(Class<T> clazz, Supplier<T> serviceAccessor) {
        return new SameClassLoaderInvocationHandler<T>(clazz, serviceAccessor);
    }

    private static class SameClassLoaderInvocationHandler<T>
    extends DynamicServiceInvocationHandler<T> {
        SameClassLoaderInvocationHandler(Class<T> serviceClass, Supplier<T> serviceAccessor) {
            super(serviceClass, serviceAccessor);
        }

        @Override
        protected Object invokeServiceMethod(Method method, Object[] args) throws Throwable {
            Object service = this.serviceAccessor.get();
            return method.invoke(service, args);
        }
    }

    private static class ClassLoaderSwitchingInvocationHandler<T>
    extends DynamicServiceInvocationHandler<T> {
        ClassLoaderSwitchingInvocationHandler(Class<T> serviceClass, Supplier<T> serviceAccessor) {
            super(serviceClass, serviceAccessor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object invokeServiceMethod(Method method, Object[] args) throws Throwable {
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Object service = this.serviceAccessor.get();
                Thread.currentThread().setContextClassLoader(service.getClass().getClassLoader());
                Object object = method.invoke(service, args);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            }
        }
    }

    static abstract class DynamicServiceInvocationHandler<T>
    implements InvocationHandler {
        private final Class<T> serviceClass;
        protected final Supplier<T> serviceAccessor;

        DynamicServiceInvocationHandler(Class<T> serviceClass, Supplier<T> serviceAccessor) {
            this.serviceAccessor = serviceAccessor;
            this.serviceClass = serviceClass;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                return this.invokeServiceMethod(method, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        protected abstract Object invokeServiceMethod(Method var1, Object[] var2) throws Throwable;

        public String toString() {
            return "OSGi Service:" + this.serviceClass.getName();
        }
    }
}

