/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.osgi;

import com.atlassian.bamboo.plugin.OsgiServiceProxyFactory;
import com.atlassian.bamboo.plugin.osgi.InvocationHandlers;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiServiceProxyFactoryImpl
implements OsgiServiceProxyFactory {
    private final long defaultTimeout;
    private final LoadingCache<Class<?>, ServiceTracker<?, ?>> serviceTrackers;
    private final PluginEventManager pluginEventManager;

    public OsgiServiceProxyFactoryImpl(PluginEventManager pluginEventManager, final OsgiContainerManager osgiContainerManager, long defaultTimeout) {
        this.pluginEventManager = pluginEventManager;
        this.defaultTimeout = defaultTimeout;
        CacheLoader cacheLoader = new CacheLoader<Class<?>, ServiceTracker<?, ?>>(){

            public ServiceTracker<?, ?> load(@NotNull Class<?> key) {
                return osgiContainerManager.getServiceTracker(key.getName());
            }
        };
        this.serviceTrackers = CacheBuilder.newBuilder().build(cacheLoader);
    }

    public <T> T createProxy(Class<T> apiClass, long timeoutInMillis) {
        Supplier<T> serviceAccessor = this.serviceAccessor(apiClass, timeoutInMillis);
        InvocationHandler h = InvocationHandlers.classLoaderSwitchingInvocationHandler(apiClass, serviceAccessor);
        return (T)Proxy.newProxyInstance(apiClass.getClassLoader(), new Class[]{apiClass}, h);
    }

    public <T> T createNonIsolatingProxy(Class<T> apiClass, long timeoutInMillis) {
        Supplier<T> serviceAccessor = this.serviceAccessor(apiClass, timeoutInMillis);
        InvocationHandler h = InvocationHandlers.nonIsolatingClassLoaderInvocationHandler(apiClass, serviceAccessor);
        return (T)Proxy.newProxyInstance(apiClass.getClassLoader(), new Class[]{apiClass}, h);
    }

    public <T> T createProxy(Class<T> apiClass) {
        return this.createProxy(apiClass, this.defaultTimeout);
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void onPluginFrameworkShutdownEvent(@NotNull PluginFrameworkShutdownEvent ignored) {
        this.serviceTrackers.invalidateAll();
    }

    @NotNull
    private <T> Supplier<T> serviceAccessor(Class<T> clazz, long timeoutInMillis) {
        return () -> {
            Object service;
            try {
                service = ((ServiceTracker)this.serviceTrackers.getUnchecked((Object)clazz)).waitForService(timeoutInMillis);
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
            if (service == null) {
                throw new ServiceTimeoutExceeded("Timeout exceeded waiting for service - " + clazz.getName());
            }
            return service;
        };
    }

    public static class ServiceTimeoutExceeded
    extends RuntimeException {
        private static final long serialVersionUID = -5140347192225812816L;

        public ServiceTimeoutExceeded(String message) {
            super(message);
        }
    }
}

