/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.predicate;

import com.atlassian.bamboo.plugin.RemoteAgentSupported;
import com.atlassian.bamboo.plugin.predicate.PluginPredicateAdapter;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.predicate.PluginPredicate;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class BambooPluginPredicates {
    private static final Set<String> REMOTE_PLUGIN_WHITELIST = ImmutableSet.of((Object)"com.atlassian.plugin.atlassian-spring-scanner-annotation", (Object)"com.atlassian.plugin.atlassian-spring-scanner-runtime");

    private BambooPluginPredicates() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static PluginPredicate alwaysTrue() {
        return PluginPredicateAdapter.adapt((Predicate<Plugin>)Predicates.alwaysTrue());
    }

    public static PluginPredicate and(PluginPredicate ... predicates) {
        return new AndPluginPredicate(predicates);
    }

    public static PluginPredicate or(PluginPredicate ... predicates) {
        return new OrPluginPredicate(predicates);
    }

    public static Predicate<Plugin> isRemoteAgentSupported() {
        return IsRemoteAgentPlugin.INSTANCE;
    }

    public static Predicate<Plugin> isBlacklisted(@NotNull Set<String> blacklist) {
        return plugin -> blacklist.contains(((Plugin)Preconditions.checkNotNull((Object)plugin)).getKey());
    }

    public static Predicate<Plugin> isUserInstalled(PluginMetadataManager pluginMetadataManager) {
        return arg_0 -> ((PluginMetadataManager)pluginMetadataManager).isUserInstalled(arg_0);
    }

    public static Predicate<Plugin> isSystemProvided(PluginMetadataManager pluginMetadataManager) {
        return arg_0 -> ((PluginMetadataManager)pluginMetadataManager).isSystemProvided(arg_0);
    }

    public static Predicate<Plugin> isAvailable() {
        return IsPluginAvailable.INSTANCE;
    }

    public static Predicate<Plugin> isEnabled(PluginAccessor pluginAccessor) {
        return plugin -> pluginAccessor.isPluginEnabled(plugin.getKey());
    }

    public static Predicate<Plugin> isBundled() {
        return IsBundledPlugin.INSTANCE;
    }

    private static final class OrPluginPredicate
    implements PluginPredicate {
        private final Iterable<PluginPredicate> predicates;

        public OrPluginPredicate(Iterable<PluginPredicate> predicates) {
            this.predicates = predicates;
        }

        public OrPluginPredicate(PluginPredicate ... predicates) {
            this(Arrays.asList(predicates));
        }

        public boolean matches(Plugin plugin) {
            for (PluginPredicate predicate : this.predicates) {
                if (!predicate.matches(plugin)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "OrPluginPredicate[predicates=" + this.predicates + "]";
        }
    }

    private static final class AndPluginPredicate
    implements PluginPredicate {
        private final Iterable<PluginPredicate> predicates;

        public AndPluginPredicate(Iterable<PluginPredicate> predicates) {
            this.predicates = predicates;
        }

        public AndPluginPredicate(PluginPredicate ... predicates) {
            this(Arrays.asList(predicates));
        }

        public boolean matches(Plugin plugin) {
            for (PluginPredicate predicate : this.predicates) {
                if (predicate.matches(plugin)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "AndPluginPredicate[predicates=" + this.predicates + "]";
        }
    }

    private static enum IsRemoteAgentPlugin implements Predicate<Plugin>
    {
        INSTANCE;


        public boolean apply(Plugin plugin) {
            if (REMOTE_PLUGIN_WHITELIST.contains(plugin.getKey())) {
                return true;
            }
            return plugin.getModuleDescriptors().stream().anyMatch(module -> module.getClass().isAnnotationPresent(RemoteAgentSupported.class));
        }
    }

    private static enum IsBundledPlugin implements Predicate<Plugin>
    {
        INSTANCE;


        public boolean apply(Plugin plugin) {
            return plugin.isBundledPlugin();
        }
    }

    private static enum IsPluginAvailable implements Predicate<Plugin>
    {
        INSTANCE;


        public boolean apply(Plugin plugin) {
            return plugin.getPluginState() != PluginState.UNINSTALLED;
        }
    }
}

