/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.servlet;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plugin.servlet.BambooContentTypeResolver;
import com.atlassian.bamboo.plugin.servlet.ContentDisposition;
import com.atlassian.bamboo.plugin.servlet.RequestPath;
import com.atlassian.bamboo.plugin.servlet.TitledFile;
import com.atlassian.bamboo.plugin.servlet.filter.HttpCompressionUtils;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.storage.location.ArtifactDirectoryBuilderImpl;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.UserNotLoggedInException;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.utils.FileCopier;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AccessDeniedException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDownloadStrategy
implements DownloadStrategy {
    protected static final Logger log = Logger.getLogger(AbstractDownloadStrategy.class);
    static final FastDateFormat LAST_MODIFIED_DATEFORMAT = FastDateFormat.getInstance((String)"E, dd MMM yyyy HH:mm:ss z", (TimeZone)TimeZone.getTimeZone("GMT"));
    private final BambooContentTypeResolver bambooContentTypeResolver;
    protected final BambooAuthenticationContext authenticationContext;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    protected final BambooPermissionManager bambooPermissionManager;
    @Inject
    private ServletContext servletContext;

    protected AbstractDownloadStrategy(AdministrationConfigurationAccessor administrationConfigurationAccessor, BambooContentTypeResolver bambooContentTypeResolver, BambooAuthenticationContext authenticationContext, BambooPermissionManager bambooPermissionManager) {
        this.bambooContentTypeResolver = bambooContentTypeResolver;
        this.authenticationContext = authenticationContext;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bambooPermissionManager = bambooPermissionManager;
    }

    @VisibleForTesting
    void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public boolean matches(String requestUri) {
        return requestUri.startsWith(this.servletContext.getContextPath() + this.getServletPath() + "/");
    }

    protected abstract String getServletPath();

    public void serveFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws DownloadException {
        try {
            this.tryServeFile(httpServletRequest, httpServletResponse);
        }
        catch (IOException e) {
            throw new DownloadException((Exception)e);
        }
    }

    private void tryServeFile(HttpServletRequest req, HttpServletResponse httpServletResponse) throws IOException {
        TitledFile titledFile;
        String pathInfo = req.getPathInfo();
        try {
            RequestPath requestPath = new RequestPath(pathInfo);
            titledFile = this.getFileToServe(requestPath, req);
        }
        catch (UserNotLoggedInException userNotLoggedInException) {
            httpServletResponse.sendRedirect(this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl() + "/userlogin!doDefault.action?os_destination=" + EscapeChars.forUrl((String)(req.getServletPath() + pathInfo)));
            return;
        }
        catch (AccessDeniedException accessDeniedException) {
            httpServletResponse.sendError(403, accessDeniedException.getMessage());
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            httpServletResponse.sendError(404);
            return;
        }
        catch (WebValidationException webValidationException) {
            httpServletResponse.sendError(400, webValidationException.getMessage());
            return;
        }
        File file = titledFile.getFile();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Serving up " + file.getAbsolutePath() + " as " + req.getRequestURI()));
        }
        if (file.isDirectory()) {
            this.serveDirectory(req, httpServletResponse, titledFile);
        } else {
            this.serveOrdinaryFile(req, httpServletResponse, file);
        }
    }

    @NotNull
    protected abstract TitledFile getFileToServe(RequestPath var1, HttpServletRequest var2) throws AccessDeniedException, FileNotFoundException, UserNotLoggedInException, WebValidationException;

    private void serveDirectory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, TitledFile titledFile) throws IOException {
        File directory = titledFile.getFile();
        File fileToServe = this.getWelcomePage(directory);
        if (fileToServe == null) {
            this.sendDirectoryListing(directory, titledFile.getTitleOrElse(directory.getName()), httpServletRequest, httpServletResponse);
        } else {
            String requestURI = httpServletRequest.getRequestURI();
            log.debug((Object)("Redirecting to " + requestURI + "/" + fileToServe.getName()));
            httpServletResponse.sendRedirect(requestURI + "/" + fileToServe.getName());
        }
    }

    private void sendDirectoryListing(File directory, String aTitle, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ArrayList<Object> directories = new ArrayList<Object>();
        ArrayList<Object> files = new ArrayList<Object>();
        StringBuilder builder = new StringBuilder(4096);
        Object[] listing = directory.listFiles();
        if (listing != null) {
            Arrays.sort(listing);
            for (Object file : listing) {
                if (((File)file).isDirectory()) {
                    directories.add(file);
                    continue;
                }
                files.add(file);
            }
        }
        ArrayList allFiles = Lists.newArrayList((Iterable)Iterables.concat(directories, files));
        String title = StringUtils.replace((String)StringUtils.replace((String)aTitle, (String)"<", (String)"&lt;"), (String)">", (String)"&gt;");
        builder.append("<HTML><HEAD><TITLE>");
        builder.append(title);
        builder.append("</TITLE></HEAD><BODY>\n<H1>");
        builder.append(title);
        builder.append("</H1><TABLE BORDER=0>");
        if (!ArtifactDirectoryBuilderImpl.isArtifactDirectory(directory)) {
            builder.append("<TR><TD><A HREF=");
            builder.append("../").append(directory.getParentFile().getName());
            builder.append(">Parent Directory</A></TD><TD></TD><TD></TD></TR>\n");
        }
        DateFormat dfmt = DateFormat.getDateTimeInstance(2, 2);
        String contextPath = httpServletRequest.getContextPath();
        String folderPath = httpServletRequest.getRequestURI();
        for (File file : allFiles) {
            builder.append("<TR><TD>");
            String image = file.isDirectory() ? "<img src=\"" + contextPath + "/images/icons/icon_folder.gif\" alt=\"(dir)\">&nbsp;" : "<img src=\"" + contextPath + "/images/icons/icon_file.gif\" alt=\"(file)\">&nbsp;";
            builder.append(image);
            builder.append("<A HREF=\"");
            builder.append(folderPath);
            if (!folderPath.endsWith("/")) {
                builder.append("/");
            }
            builder.append(EscapeChars.forUrl((String)file.getName()));
            builder.append("\">");
            builder.append(StringUtils.replace((String)StringUtils.replace((String)file.getName(), (String)"<", (String)"&lt;"), (String)">", (String)"&gt;"));
            builder.append("</a>&nbsp;");
            builder.append("</TD><TD ALIGN=right>");
            builder.append(file.length());
            builder.append(" bytes&nbsp;</TD><TD>");
            builder.append(dfmt.format(new Date(file.lastModified())));
            builder.append("</TD></TR>\n");
        }
        builder.append("</TABLE>\n");
        builder.append("</BODY></HTML>");
        httpServletResponse.setContentType("text/html");
        try {
            httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
            httpServletResponse.getWriter().write(builder.toString());
        }
        catch (IOException e) {
            log.error((Object)("Failed to stream html directory : " + directory.getAbsolutePath()), (Throwable)e);
            httpServletResponse.sendError(403);
        }
    }

    @Nullable
    private File getWelcomePage(File directory) {
        if (!this.administrationConfigurationAccessor.getAdministrationConfiguration().getResolveArtifactContentTypeByExtension()) {
            return null;
        }
        Object[] files = directory.listFiles((directory1, filename) -> filename.equals("index.html") || filename.equals("index.htm"));
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return files[0];
        }
        return null;
    }

    private void serveOrdinaryFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File fileToServe) throws IOException {
        if (fileToServe.exists() && fileToServe.canRead()) {
            Optional<String> dispositionParam = Optional.ofNullable(httpServletRequest.getParameter("disposition"));
            Optional<ContentDisposition> dispositionOpt = dispositionParam.flatMap(ContentDisposition.fFromString);
            this.sendOrdinaryFile(fileToServe, dispositionOpt.orElse(ContentDisposition.INLINE), httpServletRequest, httpServletResponse);
        } else {
            log.error((Object)("File does not exist/can't be read: " + fileToServe.getAbsolutePath()));
            httpServletResponse.sendError(404);
        }
    }

    private void sendOrdinaryFile(File fileToServe, ContentDisposition preferredDisposition, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String mimeType = this.bambooContentTypeResolver.getContentType(fileToServe.getName());
        httpServletResponse.setHeader("Last-Modified", LAST_MODIFIED_DATEFORMAT.format(new Date(fileToServe.lastModified())));
        ContentDisposition disposition = this.administrationConfigurationAccessor.getAdministrationConfiguration().getResolveArtifactContentTypeByExtension() && this.inlineable(mimeType) ? preferredDisposition : (mimeType.startsWith("text/plain") ? preferredDisposition : ContentDisposition.ATTACHMENT);
        httpServletResponse.setContentType(mimeType);
        httpServletResponse.setHeader("Content-disposition", disposition.withFile(fileToServe));
        try {
            String acceptEncodingHeader = this.isCompressionEnabled() ? httpServletRequest.getHeader("Accept-Encoding") : null;
            OutputStream outputStream = HttpCompressionUtils.getOutputStream(httpServletRequest, httpServletResponse, acceptEncodingHeader, fileToServe);
            FileCopier.copyStreams(new FileInputStream(fileToServe), outputStream);
        }
        catch (FileCopier.IoInputException e) {
            log.error((Object)("Failed to read : " + fileToServe.getAbsolutePath()), (Throwable)e);
            httpServletResponse.sendError(403);
        }
        catch (FileCopier.IoOutputException e) {
            log.info((Object)("Connection closed while serving file: " + fileToServe.getAbsolutePath() + " " + e.toString()));
        }
    }

    protected void throwPermissionException(RequestPath requestPath) throws UserNotLoggedInException, AccessDeniedException {
        String requestURI = this.getServletPath() + "/" + requestPath.getRelativePath();
        log.error((Object)("Access denied for downloads URL " + requestURI));
        if (this.authenticationContext.getUser() == null) {
            throw new UserNotLoggedInException();
        }
        throw new AccessDeniedException("You do not have access to the item: " + requestURI);
    }

    protected boolean isCompressionEnabled() {
        boolean isArtifactCompressionDarkFeatureEnabled = SystemProperty.ARTIFACT_COMPRESSION_DARK_FEATURE.getValue(false);
        return isArtifactCompressionDarkFeatureEnabled && ((AdministrationConfiguration)ComponentAccessor.PROTOTYPE_ADMINISTRATION_CONFIGURATION.get()).isUseGzipCompression();
    }

    private boolean inlineable(String mimeType) {
        return mimeType.startsWith("image") || mimeType.startsWith("text") || "application/xml".equals(mimeType);
    }
}

