/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.servlet;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.servlet.AbstractDownloadStrategy;
import com.atlassian.bamboo.plugin.servlet.BambooContentTypeResolver;
import com.atlassian.bamboo.plugin.servlet.RequestPath;
import com.atlassian.bamboo.plugin.servlet.SymbolicBuildReference;
import com.atlassian.bamboo.plugin.servlet.TitledFile;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.storage.ArtifactDirectoryBuilder;
import com.atlassian.bamboo.storage.ArtifactPathBuilder;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.UserNotLoggedInException;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDownloadStrategy
extends AbstractDownloadStrategy {
    private static final Logger log = Logger.getLogger(ArtifactDownloadStrategy.class);
    public static final String SERVLET_PATH = "/artifact";
    private static final String PATH_SEGMENT_SHARED = "shared";
    private static final Pattern PATH_SEGMENT_BUILD_NUMBER_PATTERN = Pattern.compile("build-(\\d+)");
    private final CachedPlanManager planManager;
    private final ResultsSummaryManager resultsSummaryManager;
    @Inject
    private StorageLocationService storageLocationService;
    @Inject
    private ArtifactDirectoryBuilder artifactDirectoryBuilder;
    private ArtifactPathBuilder pathBuilder;

    public ArtifactDownloadStrategy(AdministrationConfigurationAccessor administrationConfigurationAccessor, BambooPermissionManager bambooPermissionManager, BambooAuthenticationContext bambooAuthenticationContext, BambooContentTypeResolver bambooContentTypeResolver, CachedPlanManager planManager, ResultsSummaryManager resultsSummaryManager) {
        super(administrationConfigurationAccessor, bambooContentTypeResolver, bambooAuthenticationContext, bambooPermissionManager);
        this.planManager = planManager;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    @PostConstruct
    public void postConstruct() {
        this.pathBuilder = this.storageLocationService.getArtifactPathBuilder('/');
    }

    @Override
    protected String getServletPath() {
        return SERVLET_PATH;
    }

    @Override
    @NotNull
    protected TitledFile getFileToServe(RequestPath requestPath, HttpServletRequest request) throws AccessDeniedException, FileNotFoundException, UserNotLoggedInException {
        ImmutablePlan chain = this.getChain(requestPath);
        this.checkReadPermission(chain, requestPath);
        String relativeArtifactPath = this.getRelativeArtifactPath(chain, requestPath);
        return this.getArtifactFile(relativeArtifactPath);
    }

    private ImmutablePlan getChain(RequestPath requestPath) {
        PlanKey chainKey = PlanKeys.getPlanKey((String)requestPath.getHead());
        return this.planManager.getPlanByKey(chainKey);
    }

    private void checkReadPermission(@Nullable ImmutablePlan plan, RequestPath requestPath) throws UserNotLoggedInException, AccessDeniedException {
        if (plan == null || !this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.READ) || !this.bambooPermissionManager.hasPermission((Permission)BambooPermission.READ, (Object)plan, null)) {
            this.throwPermissionException(requestPath);
        }
    }

    private String getRelativeArtifactPath(ImmutablePlan chain, RequestPath requestPath) throws FileNotFoundException {
        int segmentCount = requestPath.getSegmentCount();
        Preconditions.checkArgument((segmentCount >= 1 ? 1 : 0) != 0);
        if (segmentCount == 1) {
            return this.pathBuilder.getChainPath(chain.getPlanKey());
        }
        PlanKey planKey = this.getPlanKey(chain.getPlanKey(), requestPath);
        if (segmentCount == 2) {
            return this.pathBuilder.getJobOrSharedPath(planKey);
        }
        int buildNumber = this.getBuildNumber(chain, requestPath.getSegment(2));
        String relativeBuildPath = this.pathBuilder.getBuildPath(PlanKeys.getPlanResultKey((PlanKey)planKey, (int)buildNumber));
        return relativeBuildPath + '/' + requestPath.subPath(3);
    }

    private PlanKey getPlanKey(PlanKey chainKey, RequestPath requestPath) {
        String jobOrSharedSegment = requestPath.getSegment(1);
        return jobOrSharedSegment.equals(PATH_SEGMENT_SHARED) ? chainKey : PlanKeys.getJobKey((PlanKey)chainKey, (String)jobOrSharedSegment);
    }

    private int getBuildNumber(ImmutablePlan chain, String buildSegment) throws FileNotFoundException {
        Matcher m = PATH_SEGMENT_BUILD_NUMBER_PATTERN.matcher(buildSegment);
        if (m.matches()) {
            return Integer.parseInt(m.group(1));
        }
        SymbolicBuildReference ref = SymbolicBuildReference.labelToReference(buildSegment);
        return this.getResultsSummary(chain, ref).getBuildNumber();
    }

    private ImmutableResultsSummary getResultsSummary(@NotNull ImmutablePlan chain, SymbolicBuildReference ref) throws FileNotFoundException {
        switch (ref) {
            case LATEST: {
                return chain.getLatestResultsSummary();
            }
            case LATEST_SUCCESSFUL: {
                return this.resultsSummaryManager.findLastResultSummaryWithState(chain.getPlanKey(), BuildState.SUCCESS, ResultsSummary.class);
            }
        }
        throw new FileNotFoundException();
    }

    @NotNull
    private TitledFile getArtifactFile(String relativeArtifactPath) throws FileNotFoundException {
        File artifactRootDirectory = this.getAndVerifyArtifactRootDirectory();
        return new TitledFile(new File(artifactRootDirectory, relativeArtifactPath));
    }

    @NotNull
    private File getAndVerifyArtifactRootDirectory() throws FileNotFoundException {
        File artifactRootDirectory = this.artifactDirectoryBuilder.getRootDirectory();
        if (!artifactRootDirectory.exists()) {
            log.error((Object)("Cannot find the artifact root directory: " + artifactRootDirectory));
            throw new FileNotFoundException();
        }
        return artifactRootDirectory;
    }
}

