/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.servlet;

import com.atlassian.bamboo.fileserver.MimeTypeLoader;
import com.atlassian.plugin.servlet.ContentTypeResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.context.ServletContextAware;

public class BambooContentTypeResolver
implements ContentTypeResolver,
ServletContextAware {
    private static final Logger log = Logger.getLogger(BambooContentTypeResolver.class);
    public static final String MIME_TYPE_CONFIGURATION_FILE = "/WEB-INF/mimetypes.xml";
    private final Map<String, String> mimeTypes = new ConcurrentHashMap<String, String>();
    private ServletContext servletContext;

    public void init() {
        this.loadMimeTypesFromConfigurationFile();
    }

    @NotNull
    public String getContentType(String requestUrl) {
        String extension;
        String mimeType;
        int extensionIndex = requestUrl.lastIndexOf(".");
        if (extensionIndex > -1 && (mimeType = this.mimeTypes.get(extension = requestUrl.substring(extensionIndex + 1))) != null) {
            return mimeType;
        }
        return "application/octet-stream";
    }

    private void loadMimeTypesFromConfigurationFile() {
        try {
            MimeTypeLoader mimeTypeLoader = new MimeTypeLoader();
            mimeTypeLoader.loadConfiguration(this.servletContext.getResourceAsStream(MIME_TYPE_CONFIGURATION_FILE));
            this.mimeTypes.putAll(mimeTypeLoader.getMimeTypes());
            log.debug((Object)("Loaded " + this.mimeTypes.size() + " mime types from " + MIME_TYPE_CONFIGURATION_FILE));
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialise the servlet's config file", (Throwable)e);
        }
    }

    public void setServletContext(@NotNull ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected Map<String, String> getMimeTypes() {
        return this.mimeTypes;
    }
}

