/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.servlet;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public enum ContentDisposition {
    INLINE("inline"),
    ATTACHMENT("attachment");

    private static final Map<String, ContentDisposition> STRING_MAPPING;
    static final Function<? super String, Optional<ContentDisposition>> fFromString;
    private final String headerValue;

    static Optional<ContentDisposition> fromString(String s) {
        return Optional.ofNullable(STRING_MAPPING.get(s));
    }

    private ContentDisposition(String headerValue) {
        this.headerValue = headerValue;
    }

    public String toString() {
        return this.headerValue;
    }

    public String withFile(File file) {
        return this.toString() + "; filename=\"" + file.getName() + "\"";
    }

    static {
        STRING_MAPPING = new HashMap<String, ContentDisposition>();
        for (ContentDisposition cd : ContentDisposition.values()) {
            STRING_MAPPING.put(cd.toString(), cd);
        }
        fFromString = ContentDisposition::fromString;
    }
}

