/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.servlet;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.external.RepositoryStoredSpecsLogService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plugin.servlet.AbstractDownloadStrategy;
import com.atlassian.bamboo.plugin.servlet.BambooContentTypeResolver;
import com.atlassian.bamboo.plugin.servlet.RequestPath;
import com.atlassian.bamboo.plugin.servlet.TitledFile;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.UserNotLoggedInException;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DefaultDownloadStrategy
extends AbstractDownloadStrategy {
    private static final Logger log = Logger.getLogger(DefaultDownloadStrategy.class);
    private static final String SERVLET_PATH = "/download";
    private static final String BUILD_LOGS_RELATIVE_PATH = "build_logs";
    private static final String SPEC_LOGS_RELATIVE_PATH = "spec_logs";
    private static final Pattern REQUEST_PATH_TAIL_BUILD_LOG_PATTERN = Pattern.compile("build_logs/.*-(\\d+)\\.log");
    private static final Pattern REQUEST_PATH_TAIL_SPEC_LOG_PATTERN = Pattern.compile("spec_logs/.*-(\\d+)\\.log");
    @Inject
    private StorageLocationService storageLocationService;
    @Inject
    private RepositoryStoredSpecsLogService repositoryStoredSpecLogService;

    public DefaultDownloadStrategy(AdministrationConfigurationAccessor administrationConfigurationAccessor, BambooPermissionManager bambooPermissionManager, BambooAuthenticationContext bambooAuthenticationContext, BambooContentTypeResolver bambooContentTypeResolver) {
        super(administrationConfigurationAccessor, bambooContentTypeResolver, bambooAuthenticationContext, bambooPermissionManager);
    }

    @Override
    protected String getServletPath() {
        return SERVLET_PATH;
    }

    @Override
    @NotNull
    protected TitledFile getFileToServe(RequestPath requestPath, HttpServletRequest request) throws AccessDeniedException, FileNotFoundException, UserNotLoggedInException {
        PlanKey planKey = PlanKeys.getPlanKey((String)requestPath.getHead());
        this.checkReadPermission(planKey, requestPath);
        return new TitledFile(this.getFile(planKey, requestPath.getTail()));
    }

    private void checkReadPermission(PlanKey planKey, RequestPath requestPath) throws UserNotLoggedInException, AccessDeniedException {
        if (!this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.READ) || !this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.READ, planKey)) {
            this.throwPermissionException(requestPath);
        }
    }

    private File getFile(PlanKey planKey, String requestPathTail) throws FileNotFoundException {
        Matcher buildLogsMatcher = REQUEST_PATH_TAIL_BUILD_LOG_PATTERN.matcher(requestPathTail);
        if (buildLogsMatcher.matches()) {
            int resultNumber = Integer.parseInt(buildLogsMatcher.group(1));
            return this.storageLocationService.getLogFile((ResultKey)PlanKeys.getPlanResultKey((PlanKey)planKey, (int)resultNumber));
        }
        Matcher specLogsMatcher = REQUEST_PATH_TAIL_SPEC_LOG_PATTERN.matcher(requestPathTail);
        if (specLogsMatcher.matches()) {
            int resultNumber = Integer.parseInt(specLogsMatcher.group(1));
            Path bambooSpecsFailureLogFile = this.repositoryStoredSpecLogService.getBambooSpecsExecutionLogFile(PlanKeys.getPlanResultKey((PlanKey)planKey, (int)resultNumber));
            return bambooSpecsFailureLogFile == null ? null : bambooSpecsFailureLogFile.toFile();
        }
        File buildDownloadDirectory = this.getAndVerifyDownloadDirectory(planKey);
        try {
            return BambooFileUtils.newFileUnderParent(buildDownloadDirectory, requestPathTail);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @NotNull
    private File getAndVerifyDownloadDirectory(PlanKey planKey) throws FileNotFoundException {
        File buildDownloadDirectory = this.storageLocationService.getBuildDownloadDataDirectory((Key)planKey);
        if (!buildDownloadDirectory.exists()) {
            log.error((Object)("Cannot find the build data for build [" + planKey + "] in [" + buildDownloadDirectory + "]"));
            throw new FileNotFoundException();
        }
        return buildDownloadDirectory;
    }
}

