/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.servlet;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.deployments.DeploymentKey;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plugin.servlet.AbstractDownloadStrategy;
import com.atlassian.bamboo.plugin.servlet.BambooContentTypeResolver;
import com.atlassian.bamboo.plugin.servlet.RequestPath;
import com.atlassian.bamboo.plugin.servlet.TitledFile;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.UserNotLoggedInException;
import java.io.File;
import java.io.FileNotFoundException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DeploymentDownloadStrategy
extends AbstractDownloadStrategy {
    private static final Logger log = Logger.getLogger(DeploymentDownloadStrategy.class);
    private static final String SERVLET_PATH = "/deployment-download";
    private final EnvironmentService environmentService;
    @Inject
    private StorageLocationService storageLocationService;

    public DeploymentDownloadStrategy(AdministrationConfigurationAccessor administrationConfigurationAccessor, BambooContentTypeResolver bambooContentTypeResolver, BambooPermissionManager bambooPermissionManager, BambooAuthenticationContext authenticationContext, EnvironmentService environmentService) {
        super(administrationConfigurationAccessor, bambooContentTypeResolver, authenticationContext, bambooPermissionManager);
        this.environmentService = environmentService;
    }

    @Override
    protected String getServletPath() {
        return SERVLET_PATH;
    }

    @Override
    @NotNull
    protected TitledFile getFileToServe(RequestPath requestPath, HttpServletRequest request) throws AccessDeniedException, UserNotLoggedInException, FileNotFoundException {
        Environment environment = this.getEnvironment(requestPath);
        this.checkReadPermission(environment, requestPath);
        File buildDownloadDirectory = this.getAndVerifyDownloadDirectory(environment.getKey());
        return new TitledFile(new File(buildDownloadDirectory, requestPath.getTail()));
    }

    private Environment getEnvironment(RequestPath requestPath) {
        long environmentId = Long.parseLong(requestPath.getHead());
        return this.environmentService.getEnvironment(environmentId);
    }

    private void checkReadPermission(Environment environment, RequestPath requestPath) throws UserNotLoggedInException, AccessDeniedException {
        if (environment == null || !this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.READ) || !this.bambooPermissionManager.hasPermission((Permission)BambooPermission.READ, (Object)environment, null)) {
            this.throwPermissionException(requestPath);
        }
    }

    @NotNull
    private File getAndVerifyDownloadDirectory(DeploymentKey environmentKey) throws FileNotFoundException {
        File buildDownloadDirectory = this.storageLocationService.getBuildDownloadDataDirectory((Key)environmentKey);
        if (!buildDownloadDirectory.exists()) {
            log.error((Object)("Cannot find the download data for environment (directory " + environmentKey + ") in " + buildDownloadDirectory + ".  "));
            throw new FileNotFoundException();
        }
        return buildDownloadDirectory;
    }
}

