/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.servlet;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.artifact.ArtifactDao;
import com.atlassian.bamboo.artifact.ArtifactPermissionService;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plugin.servlet.AbstractDownloadStrategy;
import com.atlassian.bamboo.plugin.servlet.BambooContentTypeResolver;
import com.atlassian.bamboo.plugin.servlet.RequestPath;
import com.atlassian.bamboo.plugin.servlet.TitledFile;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.storage.ArtifactDirectoryBuilder;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.UserNotLoggedInException;
import java.io.File;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;

public class GlobalArtifactDownloadStrategy
extends AbstractDownloadStrategy {
    public static final String SERVLET_PATH = "/global-artifact";
    private final ArtifactPermissionService artifactPermissionService;
    @Inject
    private ArtifactDao artifactDao;
    @Inject
    private ArtifactDirectoryBuilder defaultArtifactDirectoryBuilder;

    public GlobalArtifactDownloadStrategy(AdministrationConfigurationAccessor administrationConfigurationAccessor, BambooPermissionManager bambooPermissionManager, BambooAuthenticationContext authenticationContext, ArtifactPermissionService artifactPermissionService, BambooContentTypeResolver bambooContentTypeResolver) {
        super(administrationConfigurationAccessor, bambooContentTypeResolver, authenticationContext, bambooPermissionManager);
        this.artifactPermissionService = artifactPermissionService;
    }

    @Override
    protected String getServletPath() {
        return SERVLET_PATH;
    }

    @Override
    @NotNull
    protected TitledFile getFileToServe(RequestPath requestPath, HttpServletRequest request) throws AccessDeniedException, UserNotLoggedInException {
        Artifact artifact = this.getArtifact(requestPath);
        this.checkReadPermission(artifact, requestPath);
        File artifactRoot = this.defaultArtifactDirectoryBuilder.getArtifactDirectory(artifact);
        Optional<String> title = requestPath.getTail().isEmpty() ? Optional.of(artifact.getLabel()) : Optional.empty();
        return new TitledFile(new File(artifactRoot, requestPath.getTail()), title);
    }

    private Artifact getArtifact(RequestPath requestPath) {
        long artifactId = Long.parseLong(requestPath.getHead());
        return this.artifactDao.findById(artifactId);
    }

    private void checkReadPermission(Artifact artifact, RequestPath requestPath) throws UserNotLoggedInException, AccessDeniedException {
        if (artifact == null || !this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.READ) || !this.artifactPermissionService.hasReadPermission(artifact)) {
            this.throwPermissionException(requestPath);
        }
    }
}

