/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.servlet;

import com.atlassian.bamboo.util.UrlUtils;
import com.google.common.base.Joiner;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class RequestPath {
    private String relativePath;
    private String tail;
    private String[] segments;

    public RequestPath(String pathInfo) {
        this.relativePath = UrlUtils.stripLeadingSlashes((String)pathInfo);
        this.splitPath();
    }

    private void splitPath() {
        int i = this.relativePath.indexOf("/");
        this.tail = i == -1 ? "" : UrlUtils.stripLeadingSlashes((String)this.relativePath.substring(i + 1));
        this.segments = this.relativePath.split("/+");
        if (this.segments.length == 1 && this.segments[0].equals("")) {
            this.segments = ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getHead() {
        return this.segments.length == 0 ? "" : this.segments[0];
    }

    public String getTail() {
        return this.tail;
    }

    public String subPath(int from) {
        if (from < this.segments.length) {
            return Joiner.on((String)"/").join(Arrays.asList(this.segments).subList(from, this.segments.length));
        }
        return "";
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public String getSegment(int i) {
        return i >= 0 && i < this.segments.length ? this.segments[i] : "";
    }
}

