/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.servlet;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.external.RepositoryStoredSpecsLogService;
import com.atlassian.bamboo.event.analytics.RssLogDownloadEvent;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plugin.servlet.AbstractDownloadStrategy;
import com.atlassian.bamboo.plugin.servlet.BambooContentTypeResolver;
import com.atlassian.bamboo.plugin.servlet.RequestPath;
import com.atlassian.bamboo.plugin.servlet.TitledFile;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.UserNotLoggedInException;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.event.api.EventPublisher;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;

public class SpecLogsDownloadStrategy
extends AbstractDownloadStrategy {
    public static final String SERVLET_PATH = "/spec-logs";
    private static final Pattern REQUEST_PATH_PATTERN = Pattern.compile("^([0-9]+)/(.+)\\.log$");
    private final RepositoryStoredSpecsLogService repositoryStoredSpecLogService;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final EventPublisher eventPublisher;

    @Inject
    public SpecLogsDownloadStrategy(AdministrationConfigurationAccessor administrationConfigurationAccessor, BambooContentTypeResolver bambooContentTypeResolver, BambooPermissionManager bambooPermissionManager, BambooAuthenticationContext authenticationContext, EventPublisher eventPublisher, RepositoryStoredSpecsLogService repositoryStoredSpecLogService, RepositoryDefinitionManager repositoryDefinitionManager) {
        super(administrationConfigurationAccessor, bambooContentTypeResolver, authenticationContext, bambooPermissionManager);
        this.eventPublisher = eventPublisher;
        this.repositoryStoredSpecLogService = repositoryStoredSpecLogService;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    @Override
    protected String getServletPath() {
        return SERVLET_PATH;
    }

    @Override
    @NotNull
    protected TitledFile getFileToServe(@NotNull RequestPath requestPath, HttpServletRequest request) throws AccessDeniedException, UserNotLoggedInException, FileNotFoundException, WebValidationException {
        long repositoryId;
        String relativePath = requestPath.getRelativePath();
        Matcher pathMatcher = REQUEST_PATH_PATTERN.matcher(relativePath);
        BambooValidationUtils.validate(pathMatcher.matches(), "Invalid request path: " + relativePath);
        String repositoryIdString = pathMatcher.group(1);
        try {
            repositoryId = Long.parseLong(repositoryIdString);
        }
        catch (NumberFormatException e) {
            throw new WebValidationException("Invalid repository id: " + repositoryIdString);
        }
        String changesetId = pathMatcher.group(2);
        RepositoryDataEntity repository = this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryId);
        if (repository == null || !this.bambooPermissionManager.hasPermission((Permission)BambooPermission.READ, (Object)repository, null)) {
            this.throwPermissionException(requestPath);
        }
        TitledFile titledFile = Optional.ofNullable(this.repositoryStoredSpecLogService.getBambooSpecsExecutionLogFile(repositoryId, changesetId)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toFile).map(TitledFile::new).orElseThrow(FileNotFoundException::new);
        this.trackReferrer(request);
        return titledFile;
    }

    private void trackReferrer(HttpServletRequest request) {
        String[] referrers;
        String referrer = null;
        if (request.getParameterMap().containsKey("referrer") && (referrers = (String[])request.getParameterMap().get("referrer")).length > 0) {
            referrer = referrers[0];
        }
        this.eventPublisher.publish((Object)new RssLogDownloadEvent(referrer));
    }
}

