/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.servlet.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.Nullable;

public class HttpCompressionUtils {
    private static final int DONT_COMPRESS_FILESS_SMALLER_THAN = 50000;
    private static final int DONT_COMPRESS_FILES_THAT_COMPRESS_WORSE_THAN = 80;

    private HttpCompressionUtils() {
    }

    public static OutputStream getOutputStream(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable String acceptEncodingHeader, File file) throws IOException {
        boolean isCompressionAccepted;
        ServletOutputStream uncompressedOutputStream = httpServletResponse.getOutputStream();
        if (acceptEncodingHeader == null || HttpCompressionUtils.isAlreadyCompressing(httpServletRequest)) {
            httpServletResponse.setHeader("Content-Length", String.valueOf(file.length()));
            return uncompressedOutputStream;
        }
        HashSet acceptedEncodings = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)acceptEncodingHeader));
        boolean isGzipAccepted = acceptedEncodings.contains("gzip");
        boolean isXgzipAccepted = acceptedEncodings.contains("x-gzip");
        boolean isDeflateAccepted = acceptedEncodings.contains("deflate");
        boolean isCompressAccepted = acceptedEncodings.contains("compress");
        boolean isXcompressAccepted = acceptedEncodings.contains("x-compress");
        boolean bl = isCompressionAccepted = isGzipAccepted || isXgzipAccepted || isDeflateAccepted || isCompressAccepted || isXcompressAccepted;
        if (isCompressionAccepted && !HttpCompressionUtils.isWorthCompressing(file)) {
            httpServletResponse.setHeader("Content-Length", String.valueOf(file.length()));
            return uncompressedOutputStream;
        }
        if (isGzipAccepted || isXgzipAccepted) {
            HttpCompressionUtils.setHeadersForCompressedStream(httpServletResponse, isGzipAccepted ? "gzip" : "x-gzip");
            return new GZIPOutputStream((OutputStream)uncompressedOutputStream);
        }
        if (isDeflateAccepted) {
            HttpCompressionUtils.setHeadersForCompressedStream(httpServletResponse, "deflate");
            return new DeflaterOutputStream((OutputStream)uncompressedOutputStream);
        }
        if (isCompressAccepted || isXcompressAccepted) {
            HttpCompressionUtils.setHeadersForCompressedStream(httpServletResponse, isCompressAccepted ? "compress" : "x-compress");
            ZipOutputStream zos = new ZipOutputStream((OutputStream)uncompressedOutputStream);
            zos.putNextEntry(new ZipEntry("need a file name"));
            return zos;
        }
        return uncompressedOutputStream;
    }

    @VisibleForTesting
    static boolean isAlreadyCompressing(HttpServletRequest httpServletRequest) {
        Object attr = httpServletRequest.getAttribute("com.github.ziplet.filter.compression.AlreadyApplied");
        return Boolean.TRUE.equals(attr);
    }

    private static boolean isWorthCompressing(File file) throws IOException {
        if (file.length() < 50000L) {
            return false;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[4096];
            int read = fis.read(bytes);
            try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(baos);){
                deflaterOutputStream.write(bytes, 0, read);
            }
            boolean bl = baos.size() * 100 / read <= 80;
            return bl;
        }
    }

    private static void setHeadersForCompressedStream(HttpServletResponse httpServletResponse, String contentEncoding) {
        httpServletResponse.setHeader("Content-Encoding", contentEncoding);
        httpServletResponse.setHeader("Vary", "Accept-Encoding");
    }
}

