/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.web;

import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.http.mime.BrowserUtils;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class BambooResourceBatchingConfiguration
implements ResourceBatchingConfiguration {
    public static final String BAMBOO_CONTEXT_BATCHING_DISABLED = "bamboo.context.batching.disable";
    private final ResourceBatchingConfiguration defaultResourceBatchingConfiguration = new DefaultResourceBatchingConfiguration();
    private final List<String> superBatchModuleCompleteKeys;

    public BambooResourceBatchingConfiguration(List<String> superBatchModuleCompleteKeys) {
        this.superBatchModuleCompleteKeys = Collections.unmodifiableList(new ArrayList<String>(superBatchModuleCompleteKeys));
    }

    public List<String> getSuperBatchModuleCompleteKeys() {
        return this.superBatchModuleCompleteKeys;
    }

    public boolean isSuperBatchingEnabled() {
        return !this.superBatchModuleCompleteKeys.isEmpty();
    }

    public boolean isContextBatchingEnabled() {
        return !Boolean.getBoolean(BAMBOO_CONTEXT_BATCHING_DISABLED) || this.isCurrentRequestIE();
    }

    public boolean isPluginWebResourceBatchingEnabled() {
        return !Boolean.getBoolean("plugin.webresource.batching.off");
    }

    public boolean isJavaScriptTryCatchWrappingEnabled() {
        String javaScriptTryCatchWrapping = System.getProperty("plugin.webresource.javascript.try.catch.wrapping");
        return javaScriptTryCatchWrapping == null || Boolean.parseBoolean(javaScriptTryCatchWrapping);
    }

    public boolean isBatchContentTrackingEnabled() {
        return this.defaultResourceBatchingConfiguration.isBatchContentTrackingEnabled();
    }

    public boolean resplitMergedContextBatchesForThisRequest() {
        return this.isCurrentRequestIE();
    }

    public boolean isSourceMapEnabled() {
        return false;
    }

    private boolean isCurrentRequestIE() {
        HttpServletRequest request = RequestCacheThreadLocal.getRequest();
        return request != null && BrowserUtils.isIE((String)request.getHeader("user-agent"));
    }
}

