/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.web;

import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork2.ActionContext;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooWebFragmentHelper
implements WebFragmentHelper {
    private static final Logger log = Logger.getLogger(BambooWebFragmentHelper.class);
    private final transient I18nBeanFactory i18nBeanFactory;
    private final HostContainer hostContainer;
    private final transient TemplateRenderer templateRenderer;

    public BambooWebFragmentHelper(I18nBeanFactory i18nBeanFactory, HostContainer hostContainer, TemplateRenderer templateRenderer) {
        this.i18nBeanFactory = i18nBeanFactory;
        this.hostContainer = hostContainer;
        this.templateRenderer = templateRenderer;
    }

    public Condition loadCondition(String className, Plugin plugin) throws ConditionLoadingException {
        return (Condition)this.loadComponent(className, plugin);
    }

    public ContextProvider loadContextProvider(String className, Plugin plugin) throws ConditionLoadingException {
        return (ContextProvider)this.loadComponent(className, plugin);
    }

    public String getI18nValue(@NotNull String key, List<?> arguments, Map<String, Object> context) {
        I18nBean i18nBean = this.i18nBeanFactory.getI18nBean(ActionContext.getContext().getLocale());
        String labelValue = i18nBean.getText(key);
        if (StringUtils.isEmpty((CharSequence)labelValue)) {
            return key;
        }
        return labelValue;
    }

    public String renderVelocityFragment(String fragment, Map<String, Object> context) {
        if (!this.needToRender(fragment)) {
            return fragment;
        }
        String parsedResult = this.templateRenderer.renderText(fragment, context);
        return parsedResult;
    }

    public <T> T loadComponent(String className, Plugin plugin) throws ConditionLoadingException {
        try {
            Class clazz = plugin.loadClass(className, this.getClass());
            ContainerManagedPlugin containerManagedPlugin = (ContainerManagedPlugin)Narrow.downTo((Object)plugin, ContainerManagedPlugin.class);
            if (containerManagedPlugin != null) {
                return (T)containerManagedPlugin.getContainerAccessor().createBean(clazz);
            }
            return (T)this.hostContainer.create(clazz);
        }
        catch (Exception e) {
            throw new ConditionLoadingException((Throwable)e);
        }
    }

    private boolean needToRender(String fragment) {
        return TextUtils.stringSet((String)fragment) && (fragment.contains("$") || fragment.contains("#"));
    }
}

