/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.web;

import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.webwork.StrutsConfiguration;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.web.renderer.RendererException;
import com.atlassian.plugin.web.renderer.WebPanelRenderer;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import freemarker.cache.WebappTemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;

public class FreemarkerWebPanelRenderer
implements WebPanelRenderer {
    private static final Logger log = Logger.getLogger(FreemarkerWebPanelRenderer.class);
    private static final String FREEMARKER = "freemarker";
    private final LoadingCache<TemplateCacheKey, String> templateCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TemplateCacheKey, String>(){

        public String load(TemplateCacheKey templateCacheKey) {
            InputStream in = templateCacheKey.plugin.getClassLoader().getResourceAsStream(templateCacheKey.templateName);
            if (in == null && (in = ((Object)((Object)this)).getClass().getResourceAsStream(templateCacheKey.templateName)) == null) {
                try {
                    WebappTemplateLoader webappTemplateloader;
                    Object templateSource;
                    ServletContext servletContext = ServletActionContext.getServletContext();
                    if (servletContext != null && (templateSource = (webappTemplateloader = new WebappTemplateLoader(servletContext)).findTemplateSource(templateCacheKey.templateName)) != null) {
                        Reader reader = webappTemplateloader.getReader(templateSource, StrutsConfiguration.getEncoding());
                        return IOUtils.toString((Reader)reader);
                    }
                    throw new RendererException(String.format("Freemarker web panel template %s not found.", templateCacheKey.templateName));
                }
                catch (Exception e) {
                    throw new RendererException(String.format("Freemarker web panel template %s could not be loaded. %s", templateCacheKey.templateName, e.getMessage()), (Throwable)e);
                }
            }
            try {
                return IOUtils.toString((InputStream)in);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not load template '" + templateCacheKey.templateName + "' for plugin '" + templateCacheKey.plugin + "'", e);
            }
        }
    });
    private final TemplateRenderer templateRenderer;

    public FreemarkerWebPanelRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public String getResourceType() {
        return FREEMARKER;
    }

    public void render(String templateName, Plugin plugin, Map<String, Object> context, Writer writer) throws RendererException, IOException {
        TemplateCacheKey templateKey = new TemplateCacheKey(plugin, templateName);
        writer.write(this.templateRenderer.renderText((String)this.templateCache.getUnchecked((Object)templateKey), context));
    }

    public String renderFragment(String fragment, Plugin plugin, Map<String, Object> context) throws RendererException {
        return this.templateRenderer.renderText(fragment, context);
    }

    public void renderFragment(Writer writer, String fragment, Plugin plugin, Map<String, Object> context) throws RendererException, IOException {
        writer.write(this.templateRenderer.renderText(fragment, context));
    }

    static final class TemplateCacheKey {
        private final Plugin plugin;
        private final String templateName;

        TemplateCacheKey(Plugin plugin, String templateName) {
            this.plugin = plugin;
            this.templateName = templateName;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.plugin).append((Object)this.templateName).toHashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof TemplateCacheKey)) {
                return false;
            }
            TemplateCacheKey rhs = (TemplateCacheKey)o;
            return new EqualsBuilder().append((Object)this.plugin, (Object)rhs.plugin).append((Object)this.templateName, (Object)rhs.templateName).isEquals();
        }
    }
}

