/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.web;

import com.atlassian.bamboo.build.CustomBuildCompleteAction;
import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.CustomBuildProcessorServer;
import com.atlassian.bamboo.build.CustomPostBuildCompletedAction;
import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.buildqueue.manager.CustomPreBuildQueuedAction;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.configuration.PlanConfigurationUiPlugin;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.ModuleAndMultiDescriptorPredicate;
import com.atlassian.bamboo.plugin.web.PlanConfigurationUIPluginHelper;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildConfigurationAwarePlugin;
import com.atlassian.bamboo.v2.build.configuration.BuildConfigurationUIPlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanConfigurationPluginUIHelperImpl
implements PlanConfigurationUIPluginHelper {
    private static final Logger log = Logger.getLogger(PlanConfigurationPluginUIHelperImpl.class);
    private static final List<Class> MODULE_TYPES_ON_JOB_PAGE = ImmutableList.of(CustomPreBuildQueuedAction.class, CustomPreBuildAction.class, CustomBuildProcessorServer.class, CustomBuildProcessor.class, CustomBuildCompleteAction.class, CustomPostBuildCompletedAction.class);
    private final PluginAccessor pluginAccessor;

    public PlanConfigurationPluginUIHelperImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @NotNull
    public <T extends BuildConfigurationAwarePlugin> Iterable<T> getBuildConfigurationPlugins(@NotNull Plan plan, @NotNull Class<T> pluginClass) {
        return Iterables.unmodifiableIterable((Iterable)Iterables.filter((Iterable)this.pluginAccessor.getEnabledModulesByClass(pluginClass), new IsApplicableToPlan(plan)));
    }

    @NotNull
    public <T extends BuildConfigurationAwarePlugin> Iterable<T> getBuildConfigurationPlugins(@NotNull Plan plan, @NotNull Class<T> pluginClass, Class<? extends ModuleDescriptor<?>> ... moduleDescriptorsClasses) {
        return Iterables.unmodifiableIterable((Iterable)Iterables.filter((Iterable)this.pluginAccessor.getModules(new ModuleAndMultiDescriptorPredicate(pluginClass, this.pluginAccessor, moduleDescriptorsClasses)), new IsApplicableToPlan(plan)));
    }

    @NotNull
    public <T extends BuildConfigurationAwarePlugin> String getViewHtml(@NotNull Plan plan, @NotNull Class<T> pluginClass) {
        StringBuilder sb = new StringBuilder();
        for (BuildConfigurationAwarePlugin plugin : this.getBuildConfigurationPlugins(plan, pluginClass)) {
            sb.append(this.getViewHtml(plugin, plan));
        }
        return sb.toString().trim();
    }

    @NotNull
    public <T extends BuildConfigurationAwarePlugin> String getEditHtml(@NotNull BuildConfiguration buildConfiguration, @NotNull Plan plan, @NotNull Class<T> pluginClass) {
        StringBuilder sb = new StringBuilder();
        for (BuildConfigurationAwarePlugin plugin : this.getBuildConfigurationPlugins(plan, pluginClass)) {
            sb.append(this.getEditHtml(plugin, buildConfiguration, plan));
        }
        return sb.toString().trim();
    }

    @NotNull
    public <T extends BuildConfigurationAwarePlugin> List<String> getViewHtmlList(@NotNull Plan plan, @NotNull Class<T> pluginClass, Class<? extends ModuleDescriptor<?>> ... moduleDescriptorsClasses) {
        ArrayList<String> htmlList = new ArrayList<String>();
        for (BuildConfigurationAwarePlugin plugin : this.getBuildConfigurationPlugins(plan, pluginClass, moduleDescriptorsClasses)) {
            try {
                String html = this.getViewHtml(plugin, plan);
                if (!StringUtils.isNotBlank((CharSequence)html)) continue;
                htmlList.add(html);
            }
            catch (Exception e) {
                log.error((Object)"Exception in while getting view html from plugin ", (Throwable)e);
            }
        }
        return htmlList;
    }

    @NotNull
    public <T extends BuildConfigurationAwarePlugin> List<String> getEditHtmlList(@NotNull BuildConfiguration buildConfiguration, @NotNull Plan plan, @NotNull Class<T> pluginClass, Class<? extends ModuleDescriptor<?>> ... moduleDescriptorsClasses) {
        ArrayList<String> htmlList = new ArrayList<String>();
        for (BuildConfigurationAwarePlugin plugin : this.getBuildConfigurationPlugins(plan, pluginClass, moduleDescriptorsClasses)) {
            try {
                String html = this.getEditHtml(plugin, buildConfiguration, plan);
                if (!StringUtils.isNotBlank((CharSequence)html)) continue;
                htmlList.add(html);
            }
            catch (Exception e) {
                log.error((Object)"Exception in while getting edit html from plugin ", (Throwable)e);
            }
        }
        return htmlList;
    }

    @Nullable
    private <T extends BuildConfigurationAwarePlugin> String getEditHtml(final T plugin, final BuildConfiguration buildConfiguration, final Plan plan) {
        return BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<String>(null){

            @Override
            public String call() {
                return plugin.getEditHtml(buildConfiguration, plan);
            }
        });
    }

    @Nullable
    private <T extends BuildConfigurationAwarePlugin> String getViewHtml(final T plugin, final Plan plan) {
        return BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<String>(null){

            @Override
            public String call() {
                return plugin.getViewHtml(plan);
            }
        });
    }

    public boolean isPluginApplicableTo(BuildConfigurationAwarePlugin module, ImmutablePlan immutablePlan) {
        PlanConfigurationUiPlugin uiPlugin = (PlanConfigurationUiPlugin)Narrow.downTo((Object)module, PlanConfigurationUiPlugin.class);
        if (uiPlugin != null && uiPlugin.isApplicableTo(immutablePlan)) {
            return true;
        }
        if (immutablePlan instanceof ImmutableJob) {
            return MODULE_TYPES_ON_JOB_PAGE.stream().anyMatch(c -> c.isInstance(module));
        }
        return false;
    }

    public List<Class> getModuleTypesOnJobPage() {
        return MODULE_TYPES_ON_JOB_PAGE;
    }

    private static class IsApplicableToPlan<T extends BuildConfigurationAwarePlugin>
    implements Predicate<T> {
        final Plan plan;

        IsApplicableToPlan(Plan plan) {
            this.plan = plan;
        }

        public boolean apply(T input) {
            BuildConfigurationUIPlugin configUIPlugin = (BuildConfigurationUIPlugin)Narrow.reinterpret(input, BuildConfigurationUIPlugin.class);
            return configUIPlugin == null || configUIPlugin.isApplicableTo(this.plan);
        }
    }
}

