/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.xwork;

import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.UnknownHandler;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BambooStrutsUnknownHandler
implements UnknownHandler {
    private static final Logger log = Logger.getLogger(BambooStrutsUnknownHandler.class);
    @Inject
    protected Configuration configuration;

    @Nullable
    public ActionConfig handleUnknownAction(String namespace, String actionName) throws XWorkException {
        String contextPath = RequestCacheThreadLocal.getNonNullRequest().getContextPath();
        log.error((Object)("There is no Action mapped for namespace [" + namespace + "] and action name [" + actionName + "] associated with context path [" + contextPath + "]."));
        return this.configuration.getRuntimeConfiguration().getActionConfig("/", "404");
    }

    @Nullable
    public Result handleUnknownResult(ActionContext actionContext, String actionName, ActionConfig actionConfig, String resultCode) throws XWorkException {
        return null;
    }

    @Nullable
    public Object handleUnknownActionMethod(Object action, String methodName) {
        throw new UnsupportedOperationException("Unknown method: " + action.getClass() + "." + methodName);
    }
}

