/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.xwork;

import com.atlassian.bamboo.plugin.xwork.PluginAwareObjectFactory;
import com.atlassian.bamboo.plugin.xwork.StrutsSpringObjectFactory;
import com.atlassian.bamboo.web.utils.ServletContextHolder;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.UnknownHandler;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.conversion.TypeConverter;
import com.opensymphony.xwork2.factory.ActionFactory;
import com.opensymphony.xwork2.factory.ConverterFactory;
import com.opensymphony.xwork2.factory.InterceptorFactory;
import com.opensymphony.xwork2.factory.ResultFactory;
import com.opensymphony.xwork2.factory.UnknownHandlerFactory;
import com.opensymphony.xwork2.factory.ValidatorFactory;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.spring.SpringObjectFactory;
import com.opensymphony.xwork2.validator.Validator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class SpringObjectFactoryProxy
extends SpringObjectFactory {
    private static final Logger log = Logger.getLogger(SpringObjectFactoryProxy.class);
    private volatile ObjectFactory delegate;
    private final StrutsSpringObjectFactory strutsSpringObjectFactory;

    @Inject
    public SpringObjectFactoryProxy(@Inject(value="struts.objectFactory.spring.autoWire", required=false) String autoWire, @Inject(value="struts.objectFactory.spring.autoWire.alwaysRespect", required=false) String alwaysAutoWire, @Inject(value="struts.objectFactory.spring.useClassCache", required=false) String useClassCacheStr) {
        this.strutsSpringObjectFactory = new PluginAwareObjectFactory(autoWire, alwaysAutoWire, useClassCacheStr);
        WebApplicationContext webApplicationContext = ServletContextHolder.getWebApplicationContext();
        if (webApplicationContext == null) {
            log.info((Object)("Deferring initialisation of " + ((Object)((Object)this)).getClass().getCanonicalName()));
            this.delegate = new ObjectFactory();
            return;
        }
        this.switchToStrutsSpringObjectFactory(webApplicationContext);
    }

    private void switchToStrutsSpringObjectFactory(WebApplicationContext webAppContext) {
        this.strutsSpringObjectFactory.init((ApplicationContext)webAppContext);
        this.delegate = this.strutsSpringObjectFactory;
    }

    public Class<?> getClassInstance(String className) throws ClassNotFoundException {
        return this.getDelegate().getClassInstance(className);
    }

    public void setClassLoader(ClassLoader cl) {
        this.delegate.setClassLoader(cl);
        this.strutsSpringObjectFactory.setClassLoader(cl);
    }

    public void setConverterFactory(ConverterFactory converterFactory) {
        this.delegate.setConverterFactory(converterFactory);
        this.strutsSpringObjectFactory.setConverterFactory(converterFactory);
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.delegate.setValidatorFactory(validatorFactory);
        this.strutsSpringObjectFactory.setValidatorFactory(validatorFactory);
    }

    public void setInterceptorFactory(InterceptorFactory interceptorFactory) {
        this.delegate.setInterceptorFactory(interceptorFactory);
        this.strutsSpringObjectFactory.setInterceptorFactory(interceptorFactory);
    }

    public void setResultFactory(ResultFactory resultFactory) {
        this.delegate.setResultFactory(resultFactory);
        this.strutsSpringObjectFactory.setResultFactory(resultFactory);
    }

    public void setActionFactory(ActionFactory actionFactory) {
        this.delegate.setActionFactory(actionFactory);
        this.strutsSpringObjectFactory.setActionFactory(actionFactory);
    }

    public void setUnknownHandlerFactory(UnknownHandlerFactory unknownHandlerFactory) {
        this.delegate.setUnknownHandlerFactory(unknownHandlerFactory);
        this.strutsSpringObjectFactory.setUnknownHandlerFactory(unknownHandlerFactory);
    }

    public void setContainer(Container container) {
        this.delegate.setContainer(container);
        this.strutsSpringObjectFactory.setContainer(container);
    }

    public Interceptor buildInterceptor(InterceptorConfig interceptorConfig, Map<String, String> interceptorRefParams) throws ConfigurationException {
        return this.getDelegate().buildInterceptor(interceptorConfig, interceptorRefParams);
    }

    public Result buildResult(ResultConfig resultConfig, Map<String, Object> extraContext) throws Exception {
        return this.getDelegate().buildResult(resultConfig, extraContext);
    }

    public Validator buildValidator(String className, Map<String, Object> params, Map<String, Object> extraContext) throws Exception {
        return this.getDelegate().buildValidator(className, params, extraContext);
    }

    public Object buildAction(String actionName, String namespace, ActionConfig config, Map<String, Object> extraContext) throws Exception {
        return this.getDelegate().buildAction(actionName, namespace, config, extraContext);
    }

    public Object buildBean(String className, Map<String, Object> extraContext) throws Exception {
        return this.getDelegate().buildBean(className, extraContext);
    }

    public Object buildBean(Class clazz, Map<String, Object> extraContext) throws Exception {
        return this.getDelegate().buildBean(clazz, extraContext);
    }

    public Object buildBean(String beanName, Map<String, Object> extraContext, boolean injectInternal) throws Exception {
        if (this.isSpringDisabled() && beanName.equals("templateRenderer")) {
            beanName = "com.atlassian.bamboo.ww2.BambooFreemarkerManager";
        }
        return this.getDelegate().buildBean(beanName, extraContext, injectInternal);
    }

    public TypeConverter buildConverter(Class<? extends TypeConverter> converterClass, Map<String, Object> extraContext) throws Exception {
        return this.getDelegate().buildConverter(converterClass, extraContext);
    }

    public UnknownHandler buildUnknownHandler(String unknownHandlerName, Map<String, Object> extraContext) throws Exception {
        return this.getDelegate().buildUnknownHandler(unknownHandlerName, extraContext);
    }

    public boolean isNoArgConstructorRequired() {
        return this.getDelegate().isNoArgConstructorRequired();
    }

    private ObjectFactory getDelegate() {
        WebApplicationContext webAppContext;
        if (this.isSpringDisabled() && (webAppContext = ServletContextHolder.getWebApplicationContext()) != null) {
            log.info((Object)"Switching to Struts-Spring object factory");
            this.switchToStrutsSpringObjectFactory(webAppContext);
        }
        return this.delegate;
    }

    private boolean isSpringDisabled() {
        return this.delegate != this.strutsSpringObjectFactory;
    }
}

